package com.elitesland.fin.application.web.workflow;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.service.unionpay.entity.enums.DocStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.SourceTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.enums.StoredOrderTypeEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepoProc;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import com.elitesland.workflow.*;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.*;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 储值单线下支付-工作流回调
 *
 * @author gyj
 * @date 2023/7/18
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SVO_OFFLINEPAY" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class OfflinePayWorkflowCallBackController implements WorkflowCallBack {

    private final RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;

    private final AccountStorageRepoProc accountStorageRepoProc;
    private final AccountFlowRpcService accountFlowRpcService;

    private final AccountStorageRepo accountStorageRepo;

    private final WorkflowService workflowService;


    /**
     * 查询单据
     */
    private RecOrderRpcPageRespVo getRecOrderRpcPageRespVo(String businessKey) {
        String sourceNo = businessKey.split("#")[0].trim();

        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setSourceNo(sourceNo);

        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);

        Assert.notEmpty(recOrderRpcPageRespVoList, "查不到收款单");
        Assert.isTrue(recOrderRpcPageRespVoList.size() == 1, "查到多条收款单");

        return recOrderRpcPageRespVoList.get(0);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);

        String tenantId = payload.getTenantId();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CommentInfo commentInfo = payload.getCommentInfo();

        //单据是否存在
        RecOrderRpcPageRespVo recOrderRpcPageRespVo = getRecOrderRpcPageRespVo(payload.getBusinessKey());

        SendPayReq accountStorage = new SendPayReq();
        accountStorage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());

        SendPayReq recOrder = new SendPayReq();
        recOrder.setWorkflowProcInstStatus(procInstStatus);
        recOrder.setId(recOrderRpcPageRespVo.getId());

        /**
         * 修改单据
         */
        switch (procInstStatus) {
            case NOTSUBMIT: // 撤回
                break;
            case INTERRUPT: // 中断执行
                break;
            case REJECTED: // 审批拒绝
                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_REJECT.getCode());
                accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_REJECT.getCode());
                break;
            case INVALID: // 作废
                break;
            case APPROVING: // 审批中
                break;
            case APPROVED: // 审批通过
                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_SUCCESS.getCode());
                recOrder.setReceiptStatus(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());

                accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_SUCCESS.getCode());
                recOrder.setWorkflowEndTime(LocalDateTime.now());
                break;
        }

        //执行
        recOrderRpcFiledRepoProc.updateRecOrder(recOrder);
        accountStorageRepoProc.updateAccountStorage(accountStorage);

        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(recOrder.getReceiptStatus()) &&
                DocStatusEnum.SVO_APPROVE_SUCCESS.getCode().equals(accountStorage.getReceiptStatus())) {
            generateAccountFlow(accountStorage);
        }
        return WorkflowResult.success(null);
    }

    private void generateAccountFlow(SendPayReq accountStorage) {
        List<AccountStorageDO> accountStorageDOList = accountStorageRepo.findByPayOrderId(accountStorage.getPayOrderId());
        Assert.notEmpty(accountStorageDOList, "储值单不存在");
        Assert.equals(accountStorageDOList.size(), 1, "存在多条储值单");
        AccountStorageDO accountStorageDO = accountStorageDOList.get(0);

        AccountFlowRpcParam rpcParam = new AccountFlowRpcParam();
        rpcParam.setSourceId(accountStorageDO.getId());
        rpcParam.setSourceDoc(SourceTypeEnum.SVO.getCode());
        rpcParam.setSourceDocType(StoredOrderTypeEnum.PREPAY.getCode());
        rpcParam.setSourceDocStatus(accountStorageDO.getReceiptStatus());
        rpcParam.setSourceDocAmount(accountStorageDO.getRemitterAmt());
        rpcParam.setSourceNo(accountStorageDO.getId().toString());
        rpcParam.setAccountHolderName(accountStorageDO.getRemitter());
        rpcParam.setAccountCode(accountStorageDO.getAccCode());
        try {
            ApiResult<Boolean> apiResult = accountFlowRpcService.generateAccountFlow(rpcParam);
            log.info("储值订单账户流水 req is {},resp is{}", rpcParam, apiResult);
        } catch (Exception e) {
            log.error("储值订单调用账户流水逻辑发生错误，req is {}，错误信息 is :{}", rpcParam, e);
        }
    }


    @PostMapping("/reject")
    @ApiOperation("审批拒绝")
    public ApiResult<Void> reject(@RequestBody RecOrderRpcPageRespVo recOrderRpcPageRespVo) {
        checkRejectParam(recOrderRpcPageRespVo);

        SendPayReq accountStorage = new SendPayReq();
        accountStorage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());
        accountStorage.setReceiptStatus(DocStatusEnum.SVO_APPROVE_REJECT.getCode());

        accountStorageRepoProc.updateAccountStorage(accountStorage);

        SendPayReq recOrder = new SendPayReq();
        recOrder.setWorkflowProcInstStatus(ProcInstStatus.INVALID);
        recOrder.setId(recOrderRpcPageRespVo.getId());
        recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVE_REJECT.getCode());

        recOrderRpcFiledRepoProc.updateRecOrder(recOrder);

        DeleteProcessPayload deleteProcessPayload = new DeleteProcessPayload();
        deleteProcessPayload.setProcInstId(recOrderRpcPageRespVo.getWorkflowProcInstId());
        workflowService.deleteProcess(deleteProcessPayload);

        return ApiResult.ok();
    }

    private void checkRejectParam(RecOrderRpcPageRespVo recOrderRpcPageRespVo){
        Assert.notEmpty(recOrderRpcPageRespVo.getSourceNo(),"来源单号必填");
        Assert.notNull(recOrderRpcPageRespVo.getId(),"id必填");
        Assert.notEmpty(recOrderRpcPageRespVo.getWorkflowProcInstId(),"流程实例id必填");


    }

}
