package com.elitesland.fin.domain.entity.payorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:01
 */
@Entity
@Table(name = "pay_order_sync_record")
@org.hibernate.annotations.Table(appliesTo = "pay_order_sync_record", comment = "付款单同步记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class PayOrderSyncRecordDO extends CustomFieldBaseModel implements Serializable {

    private static final long serialVersionUID = 4517983643339148465L;

    @Column(name = "pay_order_id", columnDefinition = "bigint(20) comment '付款单ID'")
    private Long payOrderId;

    @Column(name = "pay_order_no", columnDefinition = "varchar(32) comment '付款单号'")
    private String payOrderNo;

    @Column(name = "business_no", columnDefinition = "varchar(32) comment '流水号'")
    private String businessNo;

    @Column(name = "seq_no", columnDefinition = "int(10) comment '序号'")
    private Integer seqNo;

    @Column(name = "sync_status", columnDefinition = "varchar(32) comment '同步状态'")
    private String syncStatus;

    @Column(name = "sync_error", columnDefinition = "varchar(32) comment '异常原因'")
    private String syncError;

    @Column(name = "out_sys_key", columnDefinition = "varchar(32) comment '外部系统标识'")
    private String outSysKey;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayOrderSyncRecordDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayOrderSyncRecordDO entity = (PayOrderSyncRecordDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
