package com.elitesland.fin.domain.service.expense;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigConvert;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepoProc;
import lombok.AllArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author Mark
 * @date 2024/08/13 18:23
 */
@Service
@AllArgsConstructor
@Transactional
public class ExpRuleConfigDomainServiceImpl implements ExpRuleConfigDomainService {

    private final ExpRuleConfigRepo expRuleConfigRepo;

    private final ExpRuleConfigRepoProc expRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<ExpRuleConfigDO> findById(Long id) {
        if (StringUtils.isEmpty(id)) {
            return Optional.empty();
        }
        return expRuleConfigRepo.findById(id);
    }

    @Override
    public List<ExpRuleConfigDO> findByIds(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return new ArrayList<>();
        }
        return expRuleConfigRepo.findAllById(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateEnableFlag(List<Long> ids, boolean enable) {
        expRuleConfigRepoProc.updateEnableFlag(ids, enable);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteById(Long id) {
        expRuleConfigRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDynamically(ExpRuleConfigDO invSceneConfigDO) {
        expRuleConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param) {
        return expRuleConfigRepoProc.searchPage(param);
    }

    @Override
    public List<ExpRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode) {
        List<ExpRuleConfigDO> sceneConfigDOS = expRuleConfigRepo.findAllByRuleCode(ruleCode);
        return sceneConfigDOS.stream().map(ExpRuleConfigConvert.INSTANCE::do2VO)
                .collect(Collectors.toList());
    }

    @Override
    public ExpRuleConfigDTO findByRuleCode(String ruleCode) {
        List<ExpRuleConfigDO> sceneConfigDOS = expRuleConfigRepo.findAllByRuleCode(ruleCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return ExpRuleConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        } else {
            return null;
        }
    }

}
