package com.elitesland.fin.infr.repo.expense;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.expense.QExpTypeDtlDO;
import com.elitesland.fin.domain.param.expense.ExpTypeDtlPageParam;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ExpTypeDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QExpTypeDtlDO qExpTypeDtlDO = QExpTypeDtlDO.expTypeDtlDO;

    public PagingVO<ExpTypeDtlDTO> page(ExpTypeDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ExpTypeDtlDTO> query = select(ExpTypeDtlDTO.class)
                .where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qExpTypeDtlDO);

        return PagingVO.<ExpTypeDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<ExpTypeDtlDTO> selectListByParam(ExpTypeDtlPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ExpTypeDtlDTO> query = select(ExpTypeDtlDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExpTypeDtlDO.id,
                qExpTypeDtlDO.masId,
                qExpTypeDtlDO.sourceLine,
                qExpTypeDtlDO.sourceDoc,
                qExpTypeDtlDO.sourceDocType,
                qExpTypeDtlDO.sourceDocStatus,
                qExpTypeDtlDO.remark,
                qExpTypeDtlDO.createTime,
                qExpTypeDtlDO.createUserId,
                qExpTypeDtlDO.creator,
                qExpTypeDtlDO.modifyTime,
                qExpTypeDtlDO.modifyUserId,
                qExpTypeDtlDO.updater,
                qExpTypeDtlDO.deleteFlag
        )).from(qExpTypeDtlDO);
    }


    private List<Predicate> where(ExpTypeDtlPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (Objects.nonNull(pageParam.getId())) {
            predicates.add(qExpTypeDtlDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qExpTypeDtlDO.id.in(pageParam.getIdList()));
        }
        if (Objects.nonNull(pageParam.getMasId())) {
            predicates.add(qExpTypeDtlDO.masId.eq(pageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIdList())) {
            predicates.add(qExpTypeDtlDO.masId.in(pageParam.getMasIdList()));
        }

        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDoc())) {
            predicates.add(qExpTypeDtlDO.sourceDoc.eq(pageParam.getSourceDoc()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocList())) {
            predicates.add(qExpTypeDtlDO.sourceDoc.in(pageParam.getSourceDocList()));
        }
        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDocType())) {
            predicates.add(qExpTypeDtlDO.sourceDocType.eq(pageParam.getSourceDocType()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocTypeList())) {
            predicates.add(qExpTypeDtlDO.sourceDocType.in(pageParam.getSourceDocTypeList()));
        }
        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDocStatus())) {
            predicates.add(qExpTypeDtlDO.sourceDocStatus.eq(pageParam.getSourceDocStatus()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocStatusList())) {
            predicates.add(qExpTypeDtlDO.sourceDocStatus.in(pageParam.getSourceDocStatusList()));
        }

        return predicates;
    }

}
