/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyArConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyArService;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinArRecVerApplyArServiceImpl
implements FinArRecVerApplyArService {
    private final FinArRecVerApplyArRepoProc finArRecVerApplyArRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ArOrderRepoProc arOrderRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinArRecVerApplyArSaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> arDocNoList = saveList.stream().map(FinArRecVerApplyArSaveDTO::getArDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArOrderDTO> arOrderDTOList = this.arOrderRepoProc.selectInOutCustByArOrderNo(arDocNoList);
        HashMap arOrderMap = CollectionUtil.isEmpty(arOrderDTOList) ? new HashMap() : arOrderDTOList.stream().collect(Collectors.toMap(ArOrderDTO::getArOrderNo, t -> t, (t1, t2) -> t1));
        this.finArRecVerApplyArRepoProc.save(saveList.stream().map(e -> {
            FinArRecVerApplyArDO entity = FinArRecVerApplyArConvert.INSTANCE.save2Do((FinArRecVerApplyArSaveDTO)e);
            entity.setMasId(masId);
            ArOrderDTO arOrderDTO = (ArOrderDTO)arOrderMap.get(entity.getArDocNo());
            if (Objects.nonNull(arOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? arOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? arOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finArRecVerApplyArRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinArRecVerApplyArVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = this.finArRecVerApplyArRepoProc.listByMasIds(masIds).stream().map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finArRecVerApplyArVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyArVOList.stream().map(FinArRecVerApplyArVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyArVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finArRecVerApplyArVOList;
    }

    @Override
    public List<FinArRecVerApplyArVO> listByQuery(FinArRecVerApplyArQuery query) {
        return this.finArRecVerApplyArRepoProc.listByQuery(query).stream().map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
    }

    @Override
    public List<FinArRecVerApplyArVO> listByOutArDocNoOrDId(FinArRecVerApplyQuery applyQuery) {
        return this.finArRecVerApplyArRepoProc.listByOutArDocNoOrDId(applyQuery);
    }

    public FinArRecVerApplyArServiceImpl(FinArRecVerApplyArRepoProc finArRecVerApplyArRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, ArOrderRepoProc arOrderRepoProc) {
        this.finArRecVerApplyArRepoProc = finArRecVerApplyArRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.arOrderRepoProc = arOrderRepoProc;
    }
}

