package com.elitesland.fin.infr.dto.aporder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.dto.aporder
 * @date 2022/3/17 11:44
 */
@Data
public class ApOrderDtlDTO implements Serializable {

    private static final long serialVersionUID = -7061989027394480359L;
    private Long id;

    private Long masId;

    private String sourceNo;

    private Integer sourceLine;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal exclTaxPrice;

    private BigDecimal price;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String remark;
    private BigDecimal verAmt;
    private BigDecimal unVerAmt;
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("协议名称")
    private String protocolName;

    @ApiModelProperty("起算日期")
    private LocalDate startCalDate;

    @ApiModelProperty("到期付款日")
    private LocalDate expirePayDate;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;

    @ApiModelProperty("库存流水ID")
    private Long invIoId;

    private Long sourceNoDid;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty("固定资产推送状态(yst-fin/AP_SYNC_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("推送日志")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

    @ApiModelProperty("财务评估类公司类型")
    private String finAssessmentOuType;
    private String finAssessmentOuTypeName;

    @ApiModelProperty(value = "财务评估类值")
    @SysCode(sys = "yst-supp", mod = "FIN_ASSESSMENT")
    private String finAssessmentValue;
    @ApiModelProperty("财务评估类值")
    private String finAssessmentValueName;

    @ApiModelProperty("采购入库仓库ID")
    private Long purRecvWhId;

    @ApiModelProperty("采购入库仓库编码")
    private String purRecvWhCode;
    private String purRecvWhName;

    @ApiModelProperty("大类编码")
    private String firstCateCode;

    @ApiModelProperty("大类名称")
    private String firstCateName;


}
