package com.elitesland.fin.application.facade.dto.financial;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author zhiyu.he
 * @date 2025/10/14 14:21
 */
@Data
public class FinancialBillDDTO extends BaseModelVO  implements Serializable {

    private static final long serialVersionUID = 4400038093517476687L;
    @ApiModelProperty("账单类型")
    @SysCode(sys = "yst-fin", mod = "FINANCIAL_BILL_DETAIL_TYPE")
    private String detailBillType;
    private String detailBillTypeName;

    @ApiModelProperty("明细金额（标准）")
    private BigDecimal detailStandardAmount;

    @ApiModelProperty("明细金额（减免）")
    private BigDecimal detailReductionAmount;

    @ApiModelProperty("明细金额（实收）")
    private BigDecimal detailActualAmount;

    @ApiModelProperty("实收未税金额")
    private BigDecimal amt;

    @ApiModelProperty("实收税额")
    private BigDecimal netAmt;

    @ApiModelProperty("账单ID")
    private Long masId;

    @ApiModelProperty("税码")
    private String taxCode;

}
