package com.elitesland.fin.domain.service.payorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.payorder.SyncRecordConvert;
import com.elitesland.fin.domain.entity.payorder.PayOrderSyncRecordDO;
import com.elitesland.fin.domain.param.payorder.SyncRecordParam;
import com.elitesland.fin.infr.dto.payorder.SyncRecordDTO;
import com.elitesland.fin.infr.repo.payorder.SyncRecordRepo;
import com.elitesland.fin.infr.repo.payorder.SyncRecordRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:52
 */
@Service
@RequiredArgsConstructor
public class SyncRecordDomainServiceImpl implements SyncRecordDomainService {

    private final SyncRecordRepo syncRecordRepo;

    private final SyncRecordRepoProc syncRecordRepoProc;


    @Override
    @SysCodeProc
    public List<SyncRecordDTO> findSyncRecord(SyncRecordParam param) {
        return syncRecordRepoProc.findSyncRecord(param);
    }

    @Override
    public Long save(SyncRecordDTO recordDTO) {
        PayOrderSyncRecordDO recordDO = SyncRecordConvert.INSTANCE.convertDO(recordDTO);
        return syncRecordRepo.save(recordDO).getId();
    }
}
