package com.elitesland.fin.application.service.app;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.application.facade.param.account.AccountAppParam;
import com.elitesland.fin.application.facade.vo.app.StoreAccountCustAppVO;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgStoreRpcServiceService;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/14
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class AppAccountServiceImpl implements AppAccountService{

    private final RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService;
    private final RmiSaleRpcService rmiSaleRpcService;

    @Override
    @SysCodeProc
    public StoreAccountCustAppVO selectCustByStore(AccountAppParam accountAppParam){
        if(StringUtils.isBlank(accountAppParam.getStoreCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店编码为空!");
        }

        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOList = rmiOrgStoreRpcServiceService.findBaseStoreByCodes(Collections.singletonList(accountAppParam.getStoreCode()));
        if (CollectionUtil.isEmpty(orgStoreBaseRpcDTOList)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未查到门店("+accountAppParam.getStoreCode()+")信息!");
        }
        StoreAccountCustAppVO storeAccountCustAppVO = new StoreAccountCustAppVO();
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreBaseRpcDTOList.get(0);

        if(StringUtils.isBlank(orgStoreBaseRpcDTO.getCustCode())){
           // throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的客户为空!");
            return storeAccountCustAppVO;
        }

        //门店客户(子客户)
        storeAccountCustAppVO.setCustCode(orgStoreBaseRpcDTO.getCustCode());
        storeAccountCustAppVO.setCustName(orgStoreBaseRpcDTO.getCustName());
        //storeAccountCustAppVO.setStoreCustType2Flag(false);


        //查看门店客户的主客户和是否是外部
        if (StringUtils.isNotBlank(storeAccountCustAppVO.getCustCode())){
            List<CustBaseDTO> custBaseInfoDTOList = rmiSaleRpcService.findBaseCustByCodes(Collections.singletonList(storeAccountCustAppVO.getCustCode()));
            if (CollectionUtil.isNotEmpty(custBaseInfoDTOList)){
                CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
                if(StringUtils.isBlank(custBaseInfoDTO.getPreCustCode())){
                    //throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的主客户为空!");
                    return storeAccountCustAppVO;
                }
                //主客户
                storeAccountCustAppVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
                storeAccountCustAppVO.setInOutCust(custBaseInfoDTO.getInOutCust());
                //主客户的信息
                if (StringUtils.isNotBlank(storeAccountCustAppVO.getStoreCustCode())){
                    List<CrmCustBaseDTO> custBaseInfoDTOS = rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(storeAccountCustAppVO.getStoreCustCode()));
                    if (CollectionUtil.isNotEmpty(custBaseInfoDTOS)) {
                        CrmCustBaseDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                        storeAccountCustAppVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                        //if (Objects.equals(custBaseInfoDTO1.getCustType2(),"A")){
                        if (Objects.equals(custBaseInfoDTO1.getInOutCust(),"OUT")){
                            storeAccountCustAppVO.setStoreCustType2Flag(true);
                        }
                    }else {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的主客户信息未查到!");
                    }
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的客户信息未查到!");
            }
        }

        return storeAccountCustAppVO;
    }

    /**
     * 根据门店编码查询客户信息-带校验提示
     *
     * @param accountAppParam 入参
     *
     * @return
     */
    @Override
    @SysCodeProc
    public StoreAccountCustAppVO selectCheckCustByStore(AccountAppParam accountAppParam){
        if(StringUtils.isBlank(accountAppParam.getStoreCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店编码为空!");
        }

        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOList = rmiOrgStoreRpcServiceService.findBaseStoreByCodes(Collections.singletonList(accountAppParam.getStoreCode()));
        if (CollectionUtil.isEmpty(orgStoreBaseRpcDTOList)){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未查到门店("+accountAppParam.getStoreCode()+")信息!");
        }
        StoreAccountCustAppVO storeAccountCustAppVO = new StoreAccountCustAppVO();
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreBaseRpcDTOList.get(0);

        if(StringUtils.isBlank(orgStoreBaseRpcDTO.getCustCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的客户为空!");
        }

        //门店客户(子客户)
        storeAccountCustAppVO.setCustCode(orgStoreBaseRpcDTO.getCustCode());
        storeAccountCustAppVO.setCustName(orgStoreBaseRpcDTO.getCustName());
        storeAccountCustAppVO.setStoreCustType2Flag(false);


        //查看门店客户的主客户和是否是外部
        if (StringUtils.isNotBlank(storeAccountCustAppVO.getCustCode())){
            List<CustBaseDTO> custBaseInfoDTOList = rmiSaleRpcService.findBaseCustByCodes(Collections.singletonList(storeAccountCustAppVO.getCustCode()));
            if (CollectionUtil.isNotEmpty(custBaseInfoDTOList)){
                CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
                if(StringUtils.isBlank(custBaseInfoDTO.getPreCustCode())){
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的主客户为空!");
                }
                //主客户
                storeAccountCustAppVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());

                //主客户的信息
                if (StringUtils.isNotBlank(storeAccountCustAppVO.getStoreCustCode())){
                    List<CrmCustBaseDTO> custBaseInfoDTOS = rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(storeAccountCustAppVO.getStoreCustCode()));
                    if (CollectionUtil.isNotEmpty(custBaseInfoDTOS)) {
                        CrmCustBaseDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                        storeAccountCustAppVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                        if (Objects.equals(custBaseInfoDTO1.getInOutCust(),"OUT")){
                            storeAccountCustAppVO.setStoreCustType2Flag(true);
                        }
                    }else {
                        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的主客户未查到!");
                    }
                }
            }else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "门店的客户未查到!");
            }
        }

        return storeAccountCustAppVO;
    }

}
