package com.elitesland.fin.application.service.saleinvd;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDtlDomainService;
import com.elitesland.fin.domain.service.saleinvd.SaleInvdDomainService;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.saleinv
 * @date 2022/5/6 15:02
 */
@Service
@RequiredArgsConstructor
public class SaleInvdServiceImpl implements SaleInvdService {

    public final SaleInvdDomainService saleInvdDomainService;

    public final InvoiceRedraftRepo invoiceRedraftRepo;

    public final SaleInvdDtlRepo saleInvdDtlRepo;

    public final SaleInvRepo saleInvRepo;

    @Override
    public void cancel(Long id) {
        saleInvdDomainService.cancel(id);
    }

    @Override
    public void red(Long id) {
        saleInvdDomainService.red(id);
    }

    @Transactional
    @Override
    public InvoiceRedraftPageVO redraft(Long id) {

        return saleInvdDomainService.redraft(id);

    }

    @Override
    public void update(SaleInvdParam param) {
        saleInvdDomainService.update(param);
    }


}
