package com.elitesland.fin.domain.service.arverrec;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.arverrec.ArVerRecDtlConvert;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDO;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtl;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtlDO;
import com.elitesland.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecDtlRepo;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecDtlRepoProc;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecRepo;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:40
 */
@Service
@RequiredArgsConstructor
public class ArVerRecDomainServiceImpl implements ArVerRecDomainService {

    private final ArVerRecRepo arVerRecRepo;
    private final ArVerRecDtlRepo arVerRecDtlRepo;
    private final ArVerRecRepoProc arVerRecRepoProc;
    private final ArVerRecDtlRepoProc arVerRecDtlRepoProc;

    private final SeqNumProvider sysNumberRuleService;



    @Override
    public Boolean queryByScId(Long scId) {
        return arVerRecDtlRepoProc.queryByScId(scId);
    }

    @Override
    public Long save(List<ArVerRecDtl> arVerRecDtls) {
        BigDecimal apVerAmt = arVerRecDtls.stream()
                .filter(t -> t.getOrderType().equals(FinConstant.AP))
                .map(ArVerRecDtl::getAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payVerAmt = arVerRecDtls.stream()
                .filter(t -> t.getOrderType().equals(FinConstant.PAY))
                .map(ArVerRecDtl::getAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        String verNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.APVER, null);
        ArVerRecDO apVerRecDO = new ArVerRecDO();
        apVerRecDO.setArVerAmt(apVerAmt);
        apVerRecDO.setRecVerAmt(payVerAmt);
        apVerRecDO.setVerNo(verNo);
        ArVerRecDO save = arVerRecRepo.save(apVerRecDO);
        if (StringUtils.isEmpty(save.toString())) {
            throw new BusinessException(ApiCode.DATABASE_EXCEPTION, "保存应收核销记录汇总表失败");
        }
        Long masId = save.getId();
        List<ArVerRecDtlDO> arVerRecDtlDOS = ArVerRecDtlConvert.INSTANCE.convertDOList(arVerRecDtls);
        arVerRecDtlDOS.forEach(t -> {
            t.setVerNo(verNo);
            t.setMasId(masId);
            t.setVerDate(LocalDateTime.now());
        });
        arVerRecDtlRepo.saveAll(arVerRecDtlDOS);
        return masId;
    }
    @Override
    public List<ArVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
        return arVerRecDtlRepoProc.queryDtlByMasIds(masIds);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long logicDelDtlByIds(Collection<Long> ids) {
        return arVerRecDtlRepoProc.logicDelByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long logicDelByIds(Collection<Long> ids,String userName,Long userId) {
        return arVerRecRepoProc.logicDelByIds(ids,userName,userId);
    }
}
