package com.elitesland.fin.application.service.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepo;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/27
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class AccountBalanceServiceImpl implements AccountBalanceService{
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;
    private final CreditAccountRepo creditAccountRepo;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final PaymentRuleConfigRepo paymentRuleConfigRepo;
    private final PaymentRuleConfigRepoProc paymentRuleConfigRepoProc;
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100);
    private final UdcProvider udcProvider;

    /**
     * 查询标准账户余额
     *
     * 如果订单金额入参有值：
     * 查询财务域对应公司+客户已经启用状态的账户可用金额；
     * 本单可用金额根据支付配置项设置的扣款比例做个计算，订单金额*扣款比例；以计算出来的值做个判断：
     * 值>账户可用金额时，若账户可用金额>0，则本单可用金额=账户可用金额，若账户可用金额<=0，则本单可用金额=0；
     * 本单可用金额=0；0<=值<=账户可用金额，本单可用金额=值；
     *
     * 注意储值账户的本单可用金额需要先判断信用账户可用金额大小，信用账户可用金额>=0时，走上述逻辑；
     * 信用账户可用金额<0时，储值账户的本单可用金额用订单金额*扣款比例的值与储值账户可用金额+信用账户可用金额 做比较。
     * 如果值>储值账户可用金额+信用账户可用金额>0，则本单可用金额=储值账户可用金额+信用账户可用金额，
     * 若储值账户可用金额+信用账户可用金额<=0，则本单可用金额=0；
     * 0<=值<=储值账户可用金额+信用账户可用金额，本单可用金额=值；
     *
     * 如果订单金额入参没有值：
     * 本单可用金额=账户可用金额。账户可用金额<=0时，本单可用金额=0
     *
     * @param param 入参
     *
     * @return
     */
    @Override
    public List<AccountBalanceVO> selectAccountBalanceByParam(AccountBalanceParam param){
        log.info("查询标准账户余额入参:{}", JSON.toJSONString(param));
        if (StringUtils.isBlank(param.getOuCode())){
            throw new BusinessException("公司编码为空");
        }
        if (StringUtils.isBlank(param.getCustCode())){
            throw new BusinessException("客户编码为空");
        }

        //查询账户列表
        AccountPageParam accountPageParam = new AccountPageParam();
        accountPageParam.setSecOuCode(param.getOuCode());
        accountPageParam.setAccountHolderCode(param.getCustCode());
        accountPageParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountVO> accountVOList = accountRepoProc.queryList(accountPageParam);

        Map<String, List<AccountVO>> accountListMap = null;
        if (CollectionUtil.isNotEmpty(accountVOList)){
            /*accountListMap = accountVOList.stream().collect(Collectors.groupingBy(
                    i -> i.getSecOuCode() + FinConstant.LINE_SPLIT + i.getAccountHolderCode() + FinConstant.LINE_SPLIT + i.getAccountType()));*/
            accountListMap = accountVOList.stream().collect(Collectors.groupingBy(i -> i.getAccountType()));

            accountListMap.forEach((key, value) -> {
                if (value.size() > 1){
                    AccountVO accountVO = value.get(0);
                    throw new BusinessException("按照公司("+accountVO.getSecOuCode()+")+" +
                            "客户("+accountVO.getAccountHolderCode()+")+账户类型("+accountVO.getAccountType()+")维度查出多个账户数据");
                }
            });
        }

        //查询信用账户列表
        CreditAccountPageParam creditAccountPageParam = new CreditAccountPageParam();
        creditAccountPageParam.setOuCode(param.getOuCode());
        creditAccountPageParam.setObjectCode(param.getCustCode());
        creditAccountPageParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountPageVO> creditAccountVOList = creditAccountRepoProc.queryList(creditAccountPageParam);

        Map<String, List<CreditAccountPageVO>> creditAccountListMap = null;
        if (CollectionUtil.isNotEmpty(creditAccountVOList)){
            /*creditAccountListMap = creditAccountVOList.stream().collect(Collectors.groupingBy(
                    i -> i.getOuCode() + FinConstant.LINE_SPLIT + i.getObjectCode() + FinConstant.LINE_SPLIT + i.getCreditAccountType()));*/
            creditAccountListMap = creditAccountVOList.stream().collect(Collectors.groupingBy(i -> i.getCreditAccountType()));

            creditAccountListMap.forEach((key, value) -> {
                if (value.size() > 1){
                    CreditAccountPageVO creditAccountPageVO = value.get(0);
                    throw new BusinessException("按照公司("+creditAccountPageVO.getOuCode()+")+" +
                            "客户("+creditAccountPageVO.getObjectCode()+")+账户类型("+creditAccountPageVO.getCreditAccountType()+")维度查出多个信用账户数据");
                }
            });
        }

        if (CollectionUtil.isEmpty(accountVOList) && CollectionUtil.isEmpty(creditAccountVOList)){
            log.info("未查询到账户信息");
            throw new BusinessException("未查询到账户信息");
        }

        // 适用账户类型
        //Map<String, String> accTypeMap = new HashMap<>();
        Map<String, String> accountTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map<String, String> creditAccountTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
       /* if (MapUtil.isNotEmpty(accountTypeUdc)){
            accTypeMap.putAll(accountTypeUdc);
        }
        if (MapUtil.isNotEmpty(creditAccountTypeUdc)){
            accTypeMap.putAll(creditAccountTypeUdc);
        }*/

        List<AccountBalanceVO> accountBalanceAllList = new ArrayList<>();

        //如果公司+主客户+账户类型查出来多个时直接报错；
        //如果只有储值账户时，走信用账户可用金额>=0时的逻辑就，只返储值账户的查询结果；
        //如果只有信用账户或者返利账户，只返这一条查询结果。
        //账户可用金额统一查账户列表的余额字段，
        //本单可用金额先根据订单金额入参做判断，再根据账户类型做判断计算最终的结果

        //1.本单可用金额先根据订单金额入参做判断，再根据账户类型做判断计算最终的结果
        if (Objects.isNull(param.getAmt())){
            List<AccountBalanceVO> accountBalanceVOList = handleAccountBalance01(accountListMap,creditAccountListMap);
            if (CollectionUtil.isNotEmpty(accountBalanceVOList)){
                accountBalanceAllList.addAll(accountBalanceVOList);
            }

        }else {

            if (StringUtils.isBlank(param.getOptDoc()) || StringUtils.isBlank(param.getOptDocType()) || StringUtils.isBlank(param.getOptDocStatus())){
                throw new BusinessException("扣款单据、扣款单据类型、扣款单据状态都不能为空");
            }

            PaymentRuleConfigParam paymentRuleConfigParam = new PaymentRuleConfigParam();
            paymentRuleConfigParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
            paymentRuleConfigParam.setOptDoc(param.getOptDoc());
            paymentRuleConfigParam.setOptDocType(param.getOptDocType());
            paymentRuleConfigParam.setOptDocStatus(param.getOptDocStatus());
            List<PaymentRuleConfigPageVO> paymentRuleConfigList = paymentRuleConfigRepoProc.selectPaymentRuleConfigByParam(paymentRuleConfigParam);
            if (CollectionUtil.isEmpty(paymentRuleConfigList)){
                throw new BusinessException("未查询到支付配置信息");
            }
            Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap =  paymentRuleConfigList.stream().collect(Collectors.groupingBy(i -> i.getOptAccountType()));
            paymentRuleConfigMap.forEach((key, value) -> {
                if (value.size() > 1){
                    //PaymentRuleConfigDtlDTO paymentRuleConfigDtlDTO = value.get(0);
                    throw new BusinessException("按照账户类型("+key+")维度查出多个支付配置数据");
                }
            });

            List<AccountBalanceVO> accountBalanceVOList = handleAccountBalance02(accountVOList,creditAccountVOList,accountListMap,creditAccountListMap,paymentRuleConfigMap,param);
            if (CollectionUtil.isNotEmpty(accountBalanceVOList)){
                accountBalanceAllList.addAll(accountBalanceVOList);
            }
        }


        if (CollectionUtil.isNotEmpty(accountBalanceAllList)){
            accountBalanceAllList.forEach(accountBalanceVO -> {
                String accType = accountBalanceVO.getAccType();
                if (StringUtils.isNotBlank(accType)){
                    //accountBalanceVO.setAccTypeName(accTypeMap.get(accountBalanceVO.getAccType()));
                    if (MapUtil.isNotEmpty(accountTypeUdc) && StringUtils.isNotBlank(accountTypeUdc.get(accType))){
                        accountBalanceVO.setAccTypeName(accountTypeUdc.get(accType));
                    }else if (MapUtil.isNotEmpty(creditAccountTypeUdc) && StringUtils.isNotBlank(creditAccountTypeUdc.get(accType))){
                        accountBalanceVO.setAccTypeName(creditAccountTypeUdc.get(accType));
                    }
                }
            });
        }

        return accountBalanceAllList;
    }


    /**
     * 查询标准账户余额
     * 如果订单金额入参没有值：
     * 本单可用金额=账户可用金额。账户可用金额<=0时，本单可用金额=0
     *
     * @param accountListMap 账户
     * @param creditAccountListMap 信用账户
     * @return
     */
    private List<AccountBalanceVO> handleAccountBalance01(Map<String, List<AccountVO>> accountListMap,Map<String, List<CreditAccountPageVO>> creditAccountListMap){

        List<AccountBalanceVO> accountBalanceVOList = new ArrayList<>();

        if (MapUtil.isNotEmpty(accountListMap)){
            accountListMap.forEach((key, value) -> {
                AccountVO accountVO = value.get(0);
                AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
                accountBalanceVO.setAccType(accountVO.getAccountType());
                accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                accountBalanceVO.setAccountName(accountVO.getAccountName());
                accountBalanceVO.setAccountAvailableAmount(accountVO.getAccountAvailableAmount());
                if(accountVO.getAccountAvailableAmount().compareTo(BigDecimal.ZERO) < 1){
                    accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                }else {
                    accountBalanceVO.setThisBillAvailableAmount(accountVO.getAccountAvailableAmount());
                }
                accountBalanceVOList.add(accountBalanceVO);
            });
        }

        if (MapUtil.isNotEmpty(creditAccountListMap)){
            creditAccountListMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = value.get(0);
                AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
                accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                accountBalanceVO.setAccountAvailableAmount(creditAccountVO.getCreditAccountAvailableLimit());
                if(creditAccountVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) < 1){
                    accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                }else {
                    accountBalanceVO.setThisBillAvailableAmount(creditAccountVO.getCreditAccountAvailableLimit());
                }
                accountBalanceVOList.add(accountBalanceVO);
            });
        }

        return accountBalanceVOList;

    }


    /**
     *
     * 如果订单金额入参有值：
     * 查询财务域对应公司+客户已经启用状态的账户可用金额；
     * 本单可用金额根据支付配置项设置的扣款比例做个计算，订单金额*扣款比例；以计算出来的值做个判断：
     * 值>账户可用金额时，若账户可用金额>0，则本单可用金额=账户可用金额，若账户可用金额<=0，则本单可用金额=0；
     * 本单可用金额=0；0<=值<=账户可用金额，本单可用金额=值；
     *
     * 注意储值账户的本单可用金额需要先判断信用账户可用金额大小，信用账户可用金额>=0时，走上述逻辑；
     * 信用账户可用金额<0时，储值账户的本单可用金额用订单金额*扣款比例的值与储值账户可用金额+信用账户可用金额 做比较。
     * 如果值>储值账户可用金额+信用账户可用金额>0，则本单可用金额=储值账户可用金额+信用账户可用金额，
     * 若储值账户可用金额+信用账户可用金额<=0，则本单可用金额=0；
     * 0<=值<=储值账户可用金额+信用账户可用金额，本单可用金额=值；
     *
     *
     * @param accountList 账户
     * @param creditAccountList 信用账户
     * @param accountMap 账户
     * @param creditAccountMap 信用账户
     * @param paymentRuleConfigMap 支付配置
     * @param accountBalanceParam 入参
     *
     * @return
     */
    private List<AccountBalanceVO> handleAccountBalance02(List<AccountVO> accountList,List<CreditAccountPageVO> creditAccountList,
                                                          Map<String, List<AccountVO>> accountMap,Map<String, List<CreditAccountPageVO>> creditAccountMap,
                                                          Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap,AccountBalanceParam accountBalanceParam){

        List<AccountBalanceVO> accountBalanceVOList = new ArrayList<>();

        Boolean accountTypeFlag = false;
        if (CollectionUtil.isNotEmpty(accountList)){
            accountTypeFlag = accountList.stream().anyMatch(accountVO -> Objects.equals(accountVO.getAccountType(),UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()));
        }
        Boolean creditAccountTypeFlag = false;
        if (CollectionUtil.isNotEmpty(creditAccountList)){
            creditAccountTypeFlag = creditAccountList.stream().anyMatch(creditAccountVO -> Objects.equals(creditAccountVO.getCreditAccountType(),UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()));
        }

        //有储值有信用走红框逻辑,既全部整体逻辑
        if (accountTypeFlag && creditAccountTypeFlag){

            accountMap.forEach((key, value) -> {
                AccountVO accountVO = value.get(0);
                //储值账户
                if (Objects.equals(key,UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())){
                    //注意储值账户的本单可用金额需要先判断信用账户可用金额大小，信用账户可用金额>=0时
                    CreditAccountPageVO creditAccountCheckVO = creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()).get(0);
                    if(creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) > -1){
                        AccountBalanceVO accountBalanceVO = handleAccountBalance0201(accountVO.getAccountType(),accountVO.getAccountAvailableAmount(),
                                paymentRuleConfigMap,accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO)){
                            accountBalanceVO.setAccType(accountVO.getAccountType());
                            accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                            accountBalanceVO.setAccountName(accountVO.getAccountName());
                            accountBalanceVOList.add(accountBalanceVO);
                        }
                    }else if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) == -1){
                        AccountBalanceVO accountBalanceVO = handleAccountBalance0202(accountVO.getAccountType(),accountVO.getAccountAvailableAmount(),
                                accountMap,creditAccountMap,
                                paymentRuleConfigMap,accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO)){
                            accountBalanceVO.setAccType(accountVO.getAccountType());
                            accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                            accountBalanceVO.setAccountName(accountVO.getAccountName());
                            accountBalanceVOList.add(accountBalanceVO);
                        }
                    }
                }else {
                    AccountBalanceVO accountBalanceVO = handleAccountBalance0201(accountVO.getAccountType(),accountVO.getAccountAvailableAmount(),
                            paymentRuleConfigMap,accountBalanceParam);
                    if (Objects.nonNull(accountBalanceVO)){
                        accountBalanceVO.setAccType(accountVO.getAccountType());
                        accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                        accountBalanceVO.setAccountName(accountVO.getAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                }

            });

            creditAccountMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = value.get(0);
                //储值账户
                if (Objects.equals(key,UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())){
                    //注意储值账户的本单可用金额需要先判断信用账户可用金额大小，信用账户可用金额>=0时
                    CreditAccountPageVO creditAccountCheckVO = creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()).get(0);
                    if(creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) > -1){
                        AccountBalanceVO accountBalanceVO = handleAccountBalance0201(creditAccountVO.getCreditAccountType(),creditAccountVO.getCreditAccountAvailableLimit(),
                                paymentRuleConfigMap,accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO)){
                            accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                            accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                            accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                            accountBalanceVOList.add(accountBalanceVO);
                        }

                    }else if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) == -1){
                        AccountBalanceVO accountBalanceVO = handleAccountBalance0202(creditAccountVO.getCreditAccountType(),creditAccountVO.getCreditAccountAvailableLimit(),
                                accountMap,creditAccountMap,
                                paymentRuleConfigMap,accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO)){
                            accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                            accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                            accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                            accountBalanceVOList.add(accountBalanceVO);
                        }
                    }
                }else {
                    AccountBalanceVO accountBalanceVO = handleAccountBalance0201(creditAccountVO.getCreditAccountType(),creditAccountVO.getCreditAccountAvailableLimit(),
                            paymentRuleConfigMap,accountBalanceParam);
                    if (Objects.nonNull(accountBalanceVO)){
                        accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                        accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                        accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                }

            });


        }else {

            accountMap.forEach((key, value) -> {
                AccountVO accountVO = value.get(0);
                AccountBalanceVO accountBalanceVO = handleAccountBalance0201(accountVO.getAccountType(),accountVO.getAccountAvailableAmount(),
                        paymentRuleConfigMap,accountBalanceParam);
                if (Objects.nonNull(accountBalanceVO)){
                    accountBalanceVO.setAccType(accountVO.getAccountType());
                    accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                    accountBalanceVO.setAccountName(accountVO.getAccountName());
                    accountBalanceVOList.add(accountBalanceVO);
                }
            });

            creditAccountMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = value.get(0);
                AccountBalanceVO accountBalanceVO = handleAccountBalance0201(creditAccountVO.getCreditAccountType(),creditAccountVO.getCreditAccountAvailableLimit(),
                        paymentRuleConfigMap,accountBalanceParam);
                if (Objects.nonNull(accountBalanceVO)){
                    accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                    accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                    accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                    accountBalanceVOList.add(accountBalanceVO);
                }
            });
        }

        return accountBalanceVOList;
    }

    /**
     *
     *
     * 本单可用金额根据支付配置项设置的扣款比例做个计算，订单金额*扣款比例；以计算出来的值做个判断：
     * 值>账户可用金额时，若账户可用金额>0，则本单可用金额=账户可用金额，若账户可用金额<=0，则本单可用金额=0；
     * 本单可用金额=0；0<=值<=账户可用金额，本单可用金额=值；
     *
     *
     * @param accountType 账户类型
     * @param accountAvailableAmount 账户可用金额
     * @param paymentRuleConfigMap 支付配置
     * @param accountBalanceParam 入参
     *
     * @return
     */
    private AccountBalanceVO handleAccountBalance0201(String accountType,BigDecimal accountAvailableAmount,
                                          Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap,AccountBalanceParam accountBalanceParam){

        AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
        accountBalanceVO.setAccountAvailableAmount(accountAvailableAmount);

        BigDecimal amt = accountBalanceParam.getAmt();
        String optAccountType = convertOptAccountType(accountType);
        if (StringUtils.isBlank(optAccountType)){
            throw new BusinessException("账户类型("+accountType+")未匹配到支付配置的账户类型");
        }
        List<PaymentRuleConfigPageVO> paymentRuleConfigList = paymentRuleConfigMap.get(optAccountType);
        if (CollectionUtil.isEmpty(paymentRuleConfigList)){
            throw new BusinessException("账户类型("+accountType+")未匹配到支付配置数据");
        }
        PaymentRuleConfigPageVO paymentRuleConfigDTO = paymentRuleConfigList.get(0);
        if (Objects.isNull(paymentRuleConfigDTO.getCalculatePercent())){
            throw new BusinessException("支付配置("+paymentRuleConfigDTO.getRuleName()+"-"+paymentRuleConfigDTO.getOptAccountType()+")的扣款比例为空！");
        }
        Integer priorityNo = paymentRuleConfigDTO.getPriorityNo();
        accountBalanceVO.setPriorityNo(priorityNo);

        BigDecimal calculatePercent = paymentRuleConfigDTO.getCalculatePercent();
        //price4 = calculatePercent.divide(DIVISOR, 8, RoundingMode.HALF_UP);
        BigDecimal calculatePercentAmt = amt.multiply(calculatePercent.divide(DIVISOR));

        if(calculatePercentAmt.compareTo(accountAvailableAmount) == 1){
            if(accountAvailableAmount.compareTo(BigDecimal.ZERO) == 1){
                accountBalanceVO.setThisBillAvailableAmount(accountAvailableAmount);
                return accountBalanceVO;
            }else if (accountAvailableAmount.compareTo(BigDecimal.ZERO) < 1){
                accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                return accountBalanceVO;
            }

        }else if ((calculatePercentAmt.compareTo(BigDecimal.ZERO) > -1) && (calculatePercentAmt.compareTo(accountAvailableAmount) < 1)){
            accountBalanceVO.setThisBillAvailableAmount(calculatePercentAmt);
            return accountBalanceVO;
        }

        return null;
    }

    /**
     *
     * 信用账户可用金额<0时，储值账户的本单可用金额用订单金额*扣款比例的值与储值账户可用金额+信用账户可用金额 做比较。
     * 如果值>储值账户可用金额+信用账户可用金额>0，则本单可用金额=储值账户可用金额+信用账户可用金额，
     * 若储值账户可用金额+信用账户可用金额<=0，则本单可用金额=0；
     * 0<=值<=储值账户可用金额+信用账户可用金额，本单可用金额=值；
     *
     * @param accountType 账户类型
     * @param accountAvailableAmount 账户可用金额
     * @param paymentRuleConfigMap 支付配置
     * @param accountBalanceParam 入参
     *
     * @return
     */
    private AccountBalanceVO handleAccountBalance0202(String accountType,BigDecimal accountAvailableAmount,
                                          Map<String, List<AccountVO>> accountMap,Map<String, List<CreditAccountPageVO>> creditAccountMap,
                                          Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap,AccountBalanceParam accountBalanceParam){

        AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
        accountBalanceVO.setAccountAvailableAmount(accountAvailableAmount);

        BigDecimal amt = accountBalanceParam.getAmt();
        String optAccountType = convertOptAccountType(accountType);
        if (StringUtils.isBlank(optAccountType)){
            throw new BusinessException("账户类型("+accountType+")未匹配到支付配置的账户类型");
        }
        List<PaymentRuleConfigPageVO> paymentRuleConfigList = paymentRuleConfigMap.get(optAccountType);
        if (CollectionUtil.isEmpty(paymentRuleConfigList)){
            throw new BusinessException("账户类型("+accountType+")未匹配到支付配置数据");
        }
        PaymentRuleConfigPageVO paymentRuleConfigDTO = paymentRuleConfigList.get(0);
        if (Objects.isNull(paymentRuleConfigDTO.getCalculatePercent())){
            throw new BusinessException("支付配置("+paymentRuleConfigDTO.getRuleName()+"-"+paymentRuleConfigDTO.getOptAccountType()+")的扣款比例为空！");
        }

        Integer priorityNo = paymentRuleConfigDTO.getPriorityNo();
        accountBalanceVO.setPriorityNo(priorityNo);

        BigDecimal calculatePercent = paymentRuleConfigDTO.getCalculatePercent();
        BigDecimal calculatePercentAmt = amt.multiply(calculatePercent.divide(DIVISOR));

        //储值账户可用金额+信用账户可用金额
        AccountVO czAccountVO = accountMap.get(UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()).get(0);
        CreditAccountPageVO xyCreditAccountPageVO = creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()).get(0);

        BigDecimal sumAmt =  czAccountVO.getAccountAvailableAmount().add(xyCreditAccountPageVO.getCreditAccountAvailableLimit());

        if((calculatePercentAmt.compareTo(sumAmt) == 1)){
            if (sumAmt.compareTo(BigDecimal.ZERO) == 1){
                accountBalanceVO.setThisBillAvailableAmount(sumAmt);
                return accountBalanceVO;
            }else if(sumAmt.compareTo(BigDecimal.ZERO) < 1){
                accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                return accountBalanceVO;
            }
        }else if ((calculatePercentAmt.compareTo(BigDecimal.ZERO) > -1) && (calculatePercentAmt.compareTo(sumAmt) < 1)){
            accountBalanceVO.setThisBillAvailableAmount(calculatePercentAmt);
            return accountBalanceVO;
        }

        return null;
    }

    private String convertOptAccountType(String accountType){
        String optAccountType = null;
        //储值账户
        if (Objects.equals(accountType,UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())){
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_STORE.getValueCode();
        }
        //返利账户
        if (Objects.equals(accountType,UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode())){
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_FLZH.getValueCode();
        }
        //信用账户
        if (Objects.equals(accountType,UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode())){
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_CREDIT.getValueCode();
        }

        return optAccountType;
    }

}
