package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class CreditAccountFlowEntity implements Serializable {
    @ApiModelProperty("授信组织/公司编码")
    private String ouCode;
    
    @ApiModelProperty("授信组织/公司名称")
    private String ouName;
    
    @ApiModelProperty("对象编码")
    private String objectCode;
    
    @ApiModelProperty("对象名称")
    private String objectName;
    
    @ApiModelProperty("对象类型")
    private String objectTypeName;
    
    @ApiModelProperty("部门编码")
    private String buCode;
    
    @ApiModelProperty("部门名称")
    private String buName;
    
    @ApiModelProperty("产品线")
    private String productLine;
    
    @ApiModelProperty("业务员")
    private String saleUser;
    
    @ApiModelProperty("流水号")
    private String flowNo;
    
    @ApiModelProperty("交易类型")
    private String transactionTypeName;
    
    @ApiModelProperty("发生金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal amount;
    
    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;
    
    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;
    
    @ApiModelProperty("信用账户名称")
    private String creditAccountName;
    
    @ApiModelProperty("信用账户类型")
    private String creditAccountTypeName;
    
    @ApiModelProperty("信用账户规则编码")
    private String creditAccountRuleCode;
    
    @ApiModelProperty("信用账户规则名称")
    private String creditAccountRuleName;
    
    @ApiModelProperty("来源单据")
    private String sourceDocName;
    
    @ApiModelProperty("来源单号")
    private String sourceNo;
    
    @ApiModelProperty("单据状态")
    private String orderStateName;
    
    @ApiModelProperty("审核人")
    private String auditUserName;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;
    
    @ApiModelProperty("规则行号")
    private Integer priorityNo;
    
    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;
    
    @ApiModelProperty("账户额度")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal creditAccountLimit;
    
    @ApiModelProperty("账户使用额度")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal creditAccountUsedLimit;
    
    @ApiModelProperty("占用额度")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal creditAccountOccupancyLimit;
    
    @ApiModelProperty("可用额度")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal creditAccountAvailableLimit;
}
