package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;

import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinApPayVerApplyService {

	/**
     * 保存核销申请单信息.
     *
     * @param save 单据信息
     * @return 主键
     */
    Long save(FinApPayVerApplySaveDTO save);

    /**
     * 提交核销申请单信息.
     *
     * @param save 单据信息
     * @return 主键
     */
    Long submit(FinApPayVerApplySaveDTO save);

    /**
     * 表头核销
     */
    Long writeOffSubmit(FinApPayVerApplySaveDTO save);


    /**
     * 下推生成核销单
     *
     * @param save
     * @return
     */
    Long writeOffCreate(FinApPayVerApplySaveDTO save);

    /**
     * 获取应收收款核销申请单明细.
     *
     * @param id 主键
     * @return 查询结果
     */
    FinApPayVerApplyVO detail(Long id);

    FinApPayVerApplyVO writeOffDetail(Long id);

    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 查询结果
     */
    PagingVO<FinApPayVerApplyVO> page(FinApPayVerApplyQuery query);

    PagingVO<FinApPayVerApplyVO> writeOffPage(FinApPayVerApplyQuery query);


    /**
     * 审批通过.
     *
     * @param dto 操作参数
     */
    void approve(FinApPayApplyApprovalDTO dto);

    void writeOffApprove(FinApPayApplyApprovalDTO dto);

/*	*//**
	 * 核销接口重试
	 * @param param
	 * @return
	 *//*
	ApiResult<String> reTrySend2Nc(ReTryParam param);*/

    /**
     * 审批拒绝.
     *
     * @param dto 操作参数
     */
    void refuse(FinApPayApplyApprovalDTO dto);

    void writeOffRefuse(FinApPayApplyApprovalDTO dto);

    /**
     * 取消核销.
     *
     * @param id 主键
     */
	void cancel(Long id);

    void writeOffCancel(Long id);


    /**
     * 根据主键集合批量删除.
     *
     * @param ids 主键集合
     */
    void deleteByIds(List<Long> ids);

    /**
     * 获取明细拆单集合.
     *
     * @param id 申请单主键
     */
    List<FinApPayVerApplySettleVO> settleList(Long id);

    public Long autoWriteoff(List<WriteoffVO> writeoffVOS,Long schemeId);

    public void autoWriteoffAp(ApOrderDTO apOrderDTO);

    public void autoWriteoffPay(PayOrderDTO payOrderDTO);
}
