package com.elitesland.fin.domain.entity.recorder;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "fin_receipt_filed_info")
@org.hibernate.annotations.Table(appliesTo = "fin_receipt_filed_info", comment = "收款单扩展表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "收款单扩展表", description = "收款单扩展表")
@Where(clause = "delete_flag = 0")
public class RecOrderRpcFiledDO extends BaseModel implements Serializable {
    //门店编码
    @Column(name = "shop_code", columnDefinition = "varchar(32) comment '门店编码'")
    private String shopCode;
    //门店名称
    @Column(name = "shop_name", columnDefinition = "varchar(32) comment '门店名称'")
    private String shopName;
    //主表id
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;
    //业务单号
    @Column(name = "service_no", columnDefinition = "varchar(32) comment '业务单号'")
    private String serviceNo;
    //业务类型
    @Column(name = "service_type", columnDefinition = "varchar(32) comment '业务类型'")
    private String serviceType;
    //支付凭证
    @Column(name = "apply_file", columnDefinition = "varchar(256) comment '支付凭证'")
    private String applyFile;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "remitter_account", columnDefinition = "varchar(32) comment '汇款银行账户'")
    private String remitterAccount;

    @Column(name = "remitter_bank_code", columnDefinition = "varchar(32) comment '汇款银行编码'")
    private String remitterBankCode;

    @Column(name = "remitter_bank_name", columnDefinition = "varchar(32) comment '汇款银行名称'")
    private String remitterBankName;

    @Column(name = "franchisee", columnDefinition = "varchar(32) comment '加盟商编码'")
    private String franchisee;

    @Column(name = "franchisee_name", columnDefinition = "varchar(32) comment '加盟商名称'")
    private String franchiseeName;
    @Column(name = "pay_bank", columnDefinition = "varchar(32) comment '付款银行'")
    private String pay_bank;
    @Column(name = "pay_account", columnDefinition = "varchar(32) comment '付款账户'")
    private String payAccount;
}
