package com.elitesland.fin.domain.service.rectype;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.rectype.RecType;
import com.elitesland.fin.domain.param.rectype.RecTypePageParam;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;

import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:27
 */
public interface RecTypeDomainService {

    /**
     * 分页查询收款单类型定义
     *
     * @param param 分页查询参数
     * @return 分页数据
     */
    PagingVO<RecTypeDTO> page(RecTypePageParam param);

    /**
     * 根据ID查询详情
     *
     * @param id 主键ID
     * @return 详情信息
     */
    RecTypeDTO queryById(Long id);

    /**
     * 设置默认
     * @param id 主键ID
     * @return id
     */
    Long makeDefault(Long id);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 主键ID
     */
    List<Long> delete(List<Long> id);

    /**
     * 查询付款单定义所有数据
     *
     * @return 付款单数据
     */
    List<RecTypeDTO> findAll();

    /**
     * 停用
     *
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> stopEnable(List<Long> ids);

    /**
     * 启用
     *
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> enable(List<Long> ids);



    /**
     * 新增收款单类型定义
     *
     * @param recType 收款单实体
     * @return 新增数据的主键ID
     */
    Long save(RecType recType);

    /**
     * 获取新增时的默认收款单类型
     *
     * @return 收款单类型信息
     */
    RecTypeDTO defaultValue();

    /**
     * 查询该收款单类型是否自动审核
     * @param code 收款单类型编码
     * @return 是否自动审核
     */
    Boolean getAuto(String code);

    /**
     * 根据主键ID查询数据
     * @param ids
     * @return
     */
    List<RecTypeDTO> queryByIds(Collection<Long> ids);

}
