package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApHeadDO;
import com.elitesland.fin.domain.entity.writeoff.QFinApPayVerApplyApHeadDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
@RequiredArgsConstructor
public class FinApPayVerApplyApHeadRepoProc {

    private final QFinApPayVerApplyApHeadDO QDO = QFinApPayVerApplyApHeadDO.finApPayVerApplyApHeadDO;

    private final JPAQueryFactory jpaQueryFactory;

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinApPayVerApplyApHeadDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

	public List<FinApPayVerApplyApHeadDO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {

        Predicate predicate = JpaPredicateBuilder.builder().getPredicate();
        if(query!=null){
            // 应付单号
            if(StringUtils.isNotBlank(query.getApOrderNo())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.apOrderNo.like("%"+query.getApOrderNo()+"%")
                );
            }
            if(null!=query.getApOperUserId()){
                predicate = ExpressionUtils.and(
                        predicate,QDO.operUserId.eq(query.getApOperUserId())
                );
            }
            if(StringUtils.isNotBlank(query.getApOuCode())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.ouCode.eq(query.getApOuCode())
                );
            }
            if(null!=query.getApSuppId()){
                predicate = ExpressionUtils.and(
                        predicate,QDO.suppId.eq(query.getApSuppId())
                );
            }
        }
        if(CollectionUtils.isNotEmpty(ids)){
            predicate = ExpressionUtils.and(
                    predicate,QDO.id.in(ids)
            );
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(query.getApConditions(), FinApPayVerApplyApHeadDO.class);
        if(customFieldPredicate!=null){
            //predicates.add(customFieldPredicate);
            predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
       //增加扩展字段查询条件end
		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.fetch();
	}
}
