/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.utils;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.infinity.utils.CsvReadListener;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import io.swagger.annotations.ApiModelProperty;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(CsvReaderUtil.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static <T> void readCsv(String filePath, Class<T> clazz, CsvReadListener<T> listener) {
        log.info("\u5f00\u59cb\u8bfb\u53d6CSV\u6587\u4ef6\uff1a{}", (Object)filePath);
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(filePath), Charset.forName("GBK"));
             CSVReader reader = new CSVReader((Reader)isr);){
            List rows = reader.readAll();
            if (rows.isEmpty()) {
                return;
            }
            String[] headers = (String[])rows.get(0);
            HashMap<String, Integer> headerIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < headers.length; ++i) {
                headerIndexMap.put(headers[i].trim(), i);
            }
            Map<String, Field> fieldMapping = CsvReaderUtil.getFieldMapping(clazz);
            for (int i = 1; i < rows.size(); ++i) {
                String[] data = (String[])rows.get(i);
                T obj = CsvReaderUtil.mapToObject(data, headerIndexMap, fieldMapping, clazz);
                listener.invoke(obj);
            }
            listener.doAfterAllAnalysed();
        }
        catch (CsvException | IOException e) {
            log.error("CSV\u8bfb\u53d6\u5931\u8d25", e);
            throw new BusinessException("CSV\u8bfb\u53d6\u5931\u8d25", e);
        }
    }

    private static <T> Map<String, Field> getFieldMapping(Class<T> clazz) {
        Field[] fields;
        HashMap<String, Field> fieldMapping = new HashMap<String, Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ApiModelProperty annotation = field.getAnnotation(ApiModelProperty.class);
            if (annotation == null || annotation.value().isEmpty()) continue;
            fieldMapping.put(annotation.value().trim(), field);
            field.setAccessible(true);
        }
        return fieldMapping;
    }

    private static <T> T mapToObject(String[] data, Map<String, Integer> headerIndexMap, Map<String, Field> fieldMapping, Class<T> clazz) {
        try {
            T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Map.Entry<String, Field> entry : fieldMapping.entrySet()) {
                String csvColumnName = entry.getKey();
                Field field = entry.getValue();
                if (!headerIndexMap.containsKey(csvColumnName)) continue;
                int columnIndex = headerIndexMap.get(csvColumnName);
                String value = columnIndex < data.length ? data[columnIndex].trim() : null;
                CsvReaderUtil.setFieldValue(obj, field, value);
            }
            return obj;
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u6620\u5c04\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5bf9\u8c61\u6620\u5c04\u5931\u8d25", e);
        }
    }

    private static void setFieldValue(Object obj, Field field, String value) throws IllegalAccessException {
        if (value == null || value.isEmpty()) {
            return;
        }
        Class<?> fieldType = field.getType();
        if (fieldType == String.class) {
            field.set(obj, value);
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            field.set(obj, Integer.parseInt(value));
        } else if (fieldType == Long.class || fieldType == Long.TYPE) {
            field.set(obj, Long.parseLong(value));
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            field.set(obj, Double.parseDouble(value));
        } else if (fieldType == BigDecimal.class || fieldType == Float.TYPE) {
            field.set(obj, new BigDecimal(value));
        } else if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            field.set(obj, Boolean.parseBoolean(value));
        } else if (fieldType == LocalDateTime.class) {
            field.set(obj, LocalDateTime.parse(value.replace("/", "-"), formatter));
        } else if (fieldType == LocalDate.class) {
            field.set(obj, LocalDate.parse(value.replace("/", "-"), formatter2));
        }
    }
}

