package com.elitesland.fin.application.facade.dto.creditaccount;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data

public class CreditAccountIocDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = 6521122525836423706L;

    @ApiModelProperty("事务码")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    private String ioName;

    @ApiModelProperty("事务类型 [UDC]FIN:IO_TYPE")
    @SysCode(sys = "yst-fin", mod = "IO_TYPE")
    private String ioType;
    @ApiModelProperty("事务类型名称")
    private String ioTypeName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("是否启用名称")
    private String statusName;
}
