package com.elitesland.fin.application.facade.param.flow;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.common.PartitionQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 账户流水;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-24
 */
@Data
@ApiModel(description = "账户流水")
public class AccountFlowPageParam extends PartitionQueryParam {
    private static final long serialVersionUID = -3699878077998652649L;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("归属加盟商编码")
    private String secFranchiseeCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易类型")
    private String transactionType;
    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("账户编码")
    private String accountCode;
    @ApiModelProperty("账户编码集合")
    private List<String> accountCodeList;

    @ApiModelProperty("账户名称")
    private String accountName;
    @ApiModelProperty("账户名称集合")
    private List<String> accountNameList;
    @ApiModelProperty("账户金额")
    private BigDecimal accountAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据集合")
    private List<String> sourceDocList;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private String sourceId;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
    @ApiModelProperty("开户主体名称集合")
    private List<String> accountHolderNameList;

    @ApiModelProperty("账户规则编码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;

    //old

    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("账户类型")
    private String accType;
    @ApiModelProperty("账户类型集合")
    private List<String> accTypeList;

    @ApiModelProperty("数据来源")
    private String dataSource;
    @ApiModelProperty("数据来源集合")
    private List<String> dataSourceList;

    @ApiModelProperty("流水号集合")
    private List<String> flowNoList;

    @ApiModelProperty("交易类型集合")
    private List<String> transactionTypeList;

    @ApiModelProperty("发生金额从")
    private BigDecimal amountFrom;

    @ApiModelProperty("发生金额至")
    private BigDecimal amountTo;

    @ApiModelProperty("交易日期起始")
    private LocalDateTime transactionTimeS;

    @ApiModelProperty("交易日期截至")
    private LocalDateTime transactionTimeE;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditDateS;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditDateE;

    @ApiModelProperty("账户编码/名称模糊查询")
    private String accKeyword;

    @ApiModelProperty("账户编码")
    private String accCode;
    @ApiModelProperty("账户编码集合")
    private List<String> accCodeList;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("来源单号-后端组装条件使用-不显示给前端")
    @JsonIgnore
    private String sourceNoEq;
    @ApiModelProperty("来源单号集合")
    private List<String> sourceNoList;

    @ApiModelProperty("账户进出方式")
    private String accIoType;
    @ApiModelProperty("账户进出方式集合")
    private List<String> accIoTypeList;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;

    @ApiModelProperty("经销商端查询日期(年月格式yyyy-MM)")
    private String yearMonthStr;

    @ApiModelProperty("修复时间")
    private LocalDateTime repairTime;

    private String rootDocNo;
}
