package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplySettleDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplySettleRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 核销申请明细拆分.
 *
 * @author shihao.ma
 * @since 2023/9/19
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplySettleServiceImpl implements FinApPayVerApplySettleService {

    private final FinApPayVerApplySettleRepoProc finApPayVerApplySettleRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplySettleSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }

        List<String> apDocNoList = saveList.stream().map(FinApPayVerApplySettleSaveDTO::getApDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ApOrderDTO> apOrderDTOList = apOrderRepoProc.selectInOutCustByApOrderNo(apDocNoList);
        Map<String, ApOrderDTO> apOrderMap = CollectionUtil.isEmpty(apOrderDTOList) ? new HashMap<>() : apOrderDTOList.stream().collect(Collectors.toMap(ApOrderDTO::getApOrderNo, t -> t, (t1, t2) -> t1));

        List<String> payDocNoList = saveList.stream().map(FinApPayVerApplySettleSaveDTO::getPayDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<PayOrderDTO> payOrderDTOList = payOrderRepoProc.selectInOutCustByPayOrderNo(payDocNoList);
        Map<String, PayOrderDTO> payOrderMap = CollectionUtil.isEmpty(payOrderDTOList) ? new HashMap<>() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1));

        finApPayVerApplySettleRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplySettleDO entity = FinApPayVerApplySettleConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);

                    ApOrderDTO apOrderDTO = apOrderMap.get(entity.getApDocNo());
                    if (Objects.nonNull(apOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getApInOutCust()) ? apOrderDTO.getInOutCust() : entity.getApInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getApRelevanceOuCode()) ? apOrderDTO.getRelevanceOuCode() : entity.getApRelevanceOuCode();
                        String apSuppCode = StringUtils.isBlank(entity.getApSuppCode()) ? apOrderDTO.getSuppCode() : entity.getApSuppCode();

                        entity.setApInOutCust(inOutCust);
                        entity.setApRelevanceOuCode(relevanceOuCode);
                        entity.setApSuppCode(apSuppCode);
                    }

                    PayOrderDTO payOrderDTO = payOrderMap.get(entity.getPayDocNo());
                    if (Objects.nonNull(payOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getPayInOutCust()) ? payOrderDTO.getInOutCust() : entity.getPayInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getPayRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getPayRelevanceOuCode();
                        String paySuppCode = StringUtils.isBlank(entity.getPaySuppCode()) ? payOrderDTO.getSuppCode() : entity.getPaySuppCode();

                        entity.setPayInOutCust(inOutCust);
                        entity.setPayRelevanceOuCode(relevanceOuCode);
                        entity.setPaySuppCode(paySuppCode);
                    }

                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    public List<FinApPayVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplySettleVO> finApPayVerApplySettleVOList = finApPayVerApplySettleRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplySettleConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplySettleVOList)){
            return Collections.EMPTY_LIST;
        }

        List<String> apRelevanceOuCodeList = finApPayVerApplySettleVOList.stream().map(FinApPayVerApplySettleVO::getApRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> payRelevanceOuCodeList = finApPayVerApplySettleVOList.stream().map(FinApPayVerApplySettleVO::getPayRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finApPayVerApplySettleVOList)){
            finApPayVerApplySettleVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouApRpcSimpleDTO = ouMap.get(v.getApRelevanceOuCode());
                if (Objects.nonNull(ouApRpcSimpleDTO)){
                    v.setApRelevanceOuName(ouApRpcSimpleDTO.getOuName());
                }

                OrgOuRpcSimpleDTO ouPayRpcSimpleDTO = ouMap.get(v.getPayRelevanceOuCode());
                if (Objects.nonNull(ouPayRpcSimpleDTO)){
                    v.setPayRelevanceOuName(ouPayRpcSimpleDTO.getOuName());
                }
            });
        }

        return finApPayVerApplySettleVOList;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (finApPayVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <=0) {
            throw new BusinessException("更新核销处理编号失败!");
        }
    }

	/**
	 * 更新核销处理核销类型
	 * @param masIds
	 * @param verFlag
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateVerFlag(Collection<Long> masIds, String verFlag) {
		if (finApPayVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <=0) {
			throw new BusinessException("更新核销处理编号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 *//*
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByArDid(String arDid, String batchNo) {
		if (finApPayVerApplySettleRepoProc.updateBatchNoByApDid(arDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}*/

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 *//*
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByRcDid(String rcDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByRcDid(rcDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}*/
}
