package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.*;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineDetailsVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.config.JobHandler;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/engine")
@RequiredArgsConstructor
@Api(value = "会计引擎", tags = {"会计引擎"})
public class FinAccountEngineController {

    private final FinAccountEngineService finAccountEngineService;
    private final JobHandler jobHandler;
    private final JournalGenerateService journalGenerateService;
    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinAccountEngineVO>> page(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.page(finAccountEngineParam));
    }

    @PostMapping("/queryFinAccountEngine")
    @ApiOperation("详情查询")
    public ApiResult<FinAccountEngineVO> queryFinAccountEngine(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.queryFinAccountEngine(finAccountEngineParam));
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdate(finAccountEngineParam));
    }

    @PostMapping("/queryFinAccountEngineDetail")
    @ApiOperation("详情查询")
    public ApiResult<FinAccountEngineVO> queryFinAccountEngineDetail(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccountEngineDetails(param));
    }

    @PostMapping("/saveOrUpdateFinAccountEngineDetail")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdateFinAccountEngineDetail(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdateFinAccountEngineDetail(finAccountEngineParam));
    }

    @PostMapping("/queryFinAccEngDetCondition")
    @ApiOperation("会计引擎详情查询")
    public ApiResult<FinAccountEngineDetailsVO> queryFinAccEngDetCondition(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccEngDetCondition(param));
    }

    @PostMapping("/saveOrUpdateFinAccEngDetCondition")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdateFinAccEngDetCondition(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdateFinAccEngDetCondition(param));
    }

    @PostMapping("/queryFinAccEngDetData")
    @ApiOperation("查询")
    public ApiResult<List<FinAccEngDetDataVO>> queryFinAccEngDetData(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccEngDetData(param));
    }

    @PostMapping("/saveOrUpdateFinAccEngDetData")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdateFinAccEngDetData(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdateFinAccEngDetData(param));
    }


    @PostMapping("/queryFinAccDetDataLine")
    @ApiOperation("数据映射查询")
    public ApiResult<List<FinAccEngDetDataLineVO>> queryFinAccDetDataLine(@RequestBody FinAccEngDetDataParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccDetDataLine(param));
    }

    @PostMapping("/saveOrUpdateFinAccDetDataLine")
    @ApiOperation("数据映射")
    public ApiResult<Long> saveOrUpdateFinAccDetDataLine(@RequestBody FinAccEngDetDataParam param) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdateFinAccEngDetDataLine(param));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        finAccountEngineService.enableOrDisable(finAccountEngineParam);
        return ApiResult.ok();
    }

    @PostMapping("loadTemplate")
    @ApiOperation("载入数据行模板")
    public ApiResult<List<FinAccEngDetDataLineVO>> loadTemplate(@RequestBody FinAccEngDetDataParam finAccEngDetDataParam) {
        return ApiResult.ok(finAccountEngineService.loadTemplate(finAccEngDetDataParam));
    }

    @PostMapping("loadTemplateNew")
    @ApiOperation("载入数据行模板-新")
    public ApiResult<List<FinAccEngDetDataLineVO>> loadTemplateNew(@RequestBody FinAccEngDetDataParam finAccEngDetDataParam) {
        return ApiResult.ok(finAccountEngineService.loadTemplateNew(finAccEngDetDataParam));
    }

    @PostMapping("loadColumnName")
    @ApiOperation("根据科目筛选科目")
    public ApiResult<List<FinAccEngDetDataLineVO>> loadColumnName(@RequestBody FinAccEngDetDateColumnParam columnParam) {
        try {
            return ApiResult.ok(finAccountEngineService.loadColumnName(columnParam));
        } catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail("加载失败：" + e.getMessage());
        }
    }

    @PostMapping("generateJournal")
    @ApiOperation("定时任务生成凭证")
    public ApiResult<Void> generateJournal(@RequestBody String engineIds) {
        jobHandler.accountJournalGenerate(engineIds);
        //finAccountEngineService.generateJournal(finAccountEngineParam);
        return ApiResult.ok();
    }
    @PostMapping("manualProposed")
    @ApiOperation("手动生成凭证")
    public ApiResult<Void> manualProposed(@RequestBody ManualProposedParam manualProposedParam) {
        journalGenerateService.manualProposed(manualProposedParam);
        return ApiResult.ok();
    }

}
