package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractDetailConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAbstractDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAbstractParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractVO;
import com.elitesland.fin.domain.entity.accountingengine.FinAbstractDO;
import com.elitesland.fin.repo.accountingengine.FinAbstractDetailRepo;
import com.elitesland.fin.repo.accountingengine.FinAbstractRepo;
import com.elitesland.fin.repo.accountingengine.FinAbstractRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinAbstractServiceImpl implements FinAbstractService {

    private final FinAbstractRepo finAbstractRepo;
    private final FinAbstractRepoProc finAbstractRepoProc;
    private final FinAbstractDetailRepo finAbstractDetailRepo;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long saveOrUpdate(FinAbstractParam param) {
        //防止npe
        param.setDetailList(Optional.ofNullable(param.getDetailList()).orElse(Collections.emptyList()));
        Assert.notEmpty(param.getCode(), "编码必填");
        Assert.notEmpty(param.getName(), "名称必填");
        Assert.notNull(param.getEventId(), "事件表单必填");

        // 校验编码是否重复
        FinAbstractDO finAbstractDO = finAbstractRepo.findByCode(param.getCode());
        if(finAbstractDO != null){
            if(param.getId() == null || !param.getId().equals(finAbstractDO.getId())){
                throw new BusinessException("编码已存在");
            }
        }

        FinAbstractDO abstractDO = FinAbstractConvert.INSTANCE.paramToDO(param);
        FinAbstractDO save = finAbstractRepo.save(abstractDO);

        finAbstractDetailRepo.deleteAllByMasId(save.getId());
        if (CollectionUtils.isNotEmpty(param.getDetailList())) {
            AtomicReference<Integer> lineNo = new AtomicReference<>(1);
            param.getDetailList().forEach(item -> {
                item.setMasId(save.getId());
                item.setLineNo(lineNo.getAndSet(lineNo.get() + 1));
            });
            finAbstractDetailRepo.saveAll(FinAbstractDetailConvert.INSTANCE.paramToDO(param.getDetailList()));
        }
        return save.getId();
    }

    @SysCodeProc
    @Override
    public PagingVO<FinAbstractVO> page(FinAbstractParam param) {
        PagingVO<FinAbstractDTO> page = finAbstractRepoProc.page(param);
        return FinAbstractConvert.INSTANCE.dtoToVo(page);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void delete(FinAbstractParam param) {
        Assert.notEmpty(param.getIdList(), "ID不能为空");
        finAbstractRepo.deleteByIdIn(param.getIdList());
        finAbstractDetailRepo.deleteAllByMasIdIn(param.getIdList());
    }

    @Override
    public void updateStatus(FinAbstractParam param) {
        finAbstractRepoProc.updateStatus(param);
    }


}
