package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.BigDecimalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aporder
 * @date 2022/3/17 11:56
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApOrderDtlDomainServiceImpl implements ApOrderDtlDomainService {

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;

    @Override
    public PagingVO<ApOrderDtlDTO> page(ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlDTO> pagingVO = apOrderDtlRepoProc.page(apOrderDtlPageParam);
        List<ApOrderDtlDTO> apOrderDtlDTOList = pagingVO.getRecords();
        if (CollectionUtil.isEmpty(apOrderDtlDTOList)){
            return PagingVO.<ApOrderDtlDTO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        List<String> dtlProtocolCodeList = apOrderDtlDTOList.stream().map(ApOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = receiptPaymentAgreementDomainService.selectPaymentAgreementByCodes(dtlProtocolCodeList);
        handleApOrderDtlDTO(apOrderDtlDTOList,agreementMap);

        return PagingVO.<ApOrderDtlDTO>builder()
                .total(pagingVO.getTotal())
                .records(apOrderDtlDTOList)
                .build();
    }

    private void handleApOrderDtlDTO(List<ApOrderDtlDTO> apOrderDtlDOS,Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (CollectionUtil.isNotEmpty(apOrderDtlDOS)){
            apOrderDtlDOS.forEach(apOrderDtlDTO -> {
                if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(apOrderDtlDTO.getProtocolCode())){
                    ReceiptPaymentAgreementVO agreementVO = agreementMap.get(apOrderDtlDTO.getProtocolCode());
                    if (Objects.nonNull(agreementVO)){
                        apOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                    }
                }
            });
        }

    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {
        Long res = apOrderDtlRepoProc.del(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void updateVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds) {
        List<ApOrderDtlDO> allByIdsIn = apOrderDtlRepoProc.findAllByIdsIn(apDIds);
        allByIdsIn.forEach(
                k -> {
                    Long orderDtlId = k.getId();
                    if (apDIdVerAmtMap.containsKey(orderDtlId)) {
                        BigDecimal thisAmt = apDIdVerAmtMap.get(orderDtlId);
                        k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).add(BigDecimalUtil.getUnify(thisAmt)));
                        k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
                    }
                }
        );
        apOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void resortVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds) {
        List<ApOrderDtlDO> allByIdsIn = apOrderDtlRepoProc.findAllByIdsIn(apDIds);
        log.info("ap待回写数据1:{}", JSONUtil.toJsonStr(allByIdsIn));
        allByIdsIn.forEach(
                k -> {
                    Long orderDtlId = k.getId();
                    if (apDIdVerAmtMap.containsKey(orderDtlId)) {
                        BigDecimal thisAmt = apDIdVerAmtMap.get(orderDtlId);
                        k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).subtract(BigDecimalUtil.getUnify(thisAmt)));
                        k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
                    }
                }
        );
        log.info("ap待回写数据2:{}", JSONUtil.toJsonStr(allByIdsIn));
        apOrderDtlRepo.saveAll(allByIdsIn);
    }

}
