/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAbstractDetailConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAbstractDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAbstractParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractDetailVO;
import com.elitesland.fin.domain.entity.accountingengine.FinAbstractDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAbstractDO;
import com.elitesland.fin.repo.accountingengine.FinAbstractDetailRepo;
import com.elitesland.fin.repo.accountingengine.FinAbstractRepo;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FinAbstractRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final FinAbstractDetailRepo finAbstractDetailRepo;
    private final FinAbstractRepo finAbstractRepo;
    private final QFinAbstractDO finAbstractDO = QFinAbstractDO.finAbstractDO;

    public PagingVO<FinAbstractDTO> page(FinAbstractParam param) {
        Predicate where = this.where(param);
        JPAQuery query = (JPAQuery)this.select(FinAbstractDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        param.setPaging(query);
        param.fillOrders(query, this.finAbstractDO);
        List abstractVOList = query.fetch();
        List<Long> ids = abstractVOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        List<FinAbstractDetailVO> detailList = FinAbstractDetailConvert.INSTANCE.doToVo(this.finAbstractDetailRepo.findAllByMasIdIn(ids));
        for (FinAbstractDTO abstractVO : abstractVOList) {
            abstractVO.setDetailList(detailList.stream().filter(detail -> abstractVO.getId().equals(detail.getMasId())).collect(Collectors.toList()));
        }
        return PagingVO.builder().total(query.fetchCount()).records(abstractVOList).build();
    }

    private Predicate where(FinAbstractParam param) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        Predicate build = BaseRepoProc.PredicateBuilder.builder().andEq(param.getEventId() != null, this.finAbstractDO.eventId, (Object)param.getEventId()).andEq(StringUtils.isNotEmpty((String)param.getCode()), (SimpleExpression)this.finAbstractDO.code, (Object)param.getCode()).andLike(StringUtils.isNotEmpty((String)param.getName()), (StringExpression)this.finAbstractDO.name, StringUtil.buildLikeString(param.getName())).andEq(param.getStatus() != null, (SimpleExpression)this.finAbstractDO.status, (Object)param.getStatus()).build();
        predicates.add(build);
        if (StringUtils.isNotEmpty((String)param.getCodeName())) {
            BooleanExpression predicate = this.finAbstractDO.code.like("%" + param.getCodeName() + "%").or((Predicate)this.finAbstractDO.name.like("%" + param.getCodeName() + "%"));
            predicates.add(predicate);
        }
        return ExpressionUtils.allOf(predicates);
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.finAbstractDO.id, this.finAbstractDO.code, this.finAbstractDO.name, this.finAbstractDO.eventId, this.finAbstractDO.eventName, this.finAbstractDO.status, this.finAbstractDO.createTime, this.finAbstractDO.creator, this.finAbstractDO.modifyTime, this.finAbstractDO.updater})).from((EntityPath)this.finAbstractDO);
    }

    @Transactional
    public void updateStatus(FinAbstractParam param) {
        this.jpaQueryFactory.update((EntityPath)this.finAbstractDO).set((Path)this.finAbstractDO.status, (Object)param.getStatus()).where(new Predicate[]{this.finAbstractDO.id.in(param.getIdList())}).execute();
    }

    public List<FinAbstractDO> findAllByCodeInAndStatus(List<String> abstractCodes, String status) {
        if (CollectionUtils.isEmpty(abstractCodes)) {
            return Lists.newArrayList();
        }
        List<FinAbstractDO> abstractDOList = this.finAbstractRepo.findAllByCodeInAndStatus(abstractCodes, status);
        Assert.notEmpty(abstractDOList, (String)"\u67e5\u4e0d\u5230\u7ec4\u5408\u8bbe\u7f6e", (Object[])new Object[0]);
        return abstractDOList;
    }

    public FinAbstractRepoProc(JPAQueryFactory jpaQueryFactory, FinAbstractDetailRepo finAbstractDetailRepo, FinAbstractRepo finAbstractRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.finAbstractDetailRepo = finAbstractDetailRepo;
        this.finAbstractRepo = finAbstractRepo;
    }
}

