package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/2/5 2:35 下午
 * @version:v1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class OperationLogService {

    private final OperationLogMqMessageService operationLogMqMessageService;  //注入操作日志服务接口

    public void simpleSendLog(String businessType, String businessParam, OperationTypeEnum operationType,
                              String operationDescription) {
        log.debug("记录日志参数,businessType:{},businessParam:{},operationType:{},operationDescription:{}",
            businessType, businessParam, operationType, operationDescription);
        OperationLogDTO dto = operationLogMqMessageService.quickNewOperationLogDTO(
            businessType,
            businessParam,
            operationType,
            operationDescription);

        //埋点操作日志发送
        operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
    }

}
