package com.elitesland.fin.infr.dto.saleinv;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Data
public class SaleInvDTO extends BaseViewModel implements Serializable {

    private Long id;

    private String sourceSysNo;

    private String applyNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private BigDecimal taxRate;

    private String invRegNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String saleInvTitle;

    private String saleTaxNo;

    private String saleTel;

    private String saleAdd;

    private String saleBank;

    private String saleBankAcc;

    private String saleRemark;

    private Long saleId;

    private String saleName;

    private String saleCode;

    private String custInvTitle;

    private String custTaxNo;

    private String custAdd;

    private String custTel;

    private String custBank;

    private String custBankAcc;

    private String custRemark;

    private Long custId;

    private String custName;

    private String custCode;

    private String invUser;

    private String recUser;

    private String revUser;

    private Long auditUserId;

    private String pushMethod;

    private String phone;

    private String email;

    private String infoNo;

    private String expressNo;

    private String invState;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private String auditRejection;

    private String createMode;

    private String invType;

    private String procInstId;

    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String invMerge;

    @ApiModelProperty("开票申请单ID")
    private Long applyId;

    @ApiModelProperty("来源单据号")
    private List<String> paymentNoList;

    @ApiModelProperty("来源单据Ids")
    private List<Long> paymentIds;

    @ApiModelProperty("红冲状态")
    private List<String> redState;

    @ApiModelProperty("发票明细")
    private List<SaleInvDtlDTO> saleInvDtlDTOList;

    @ApiModelProperty("已开发票明细")
    private List<SaleInvdDtlDTO> saleInvdDtlDTOList;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("开票客户名称")
    private String invCustName;

    @ApiModelProperty("开票客户编码")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    private Long invCustId;

    @ApiModelProperty("开票日期")
    private LocalDateTime drawDate;
    /**
     * 发票明细行，是否均为红冲状态
     */
    public boolean isRedState() {
        return CollUtil.isNotEmpty(redState) && redState.stream().allMatch(row -> row.equals("3"));
    }
    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

//    @ApiModelProperty("集团编码")
//    private String es1;
//
//    @ApiModelProperty("开票类型编码")
//    private String es2;
//
//    @ApiModelProperty("结算方式")
//    private String settlementType;
}
