/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.invoiceredraft;

import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftQueryParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class InvoiceRedraftRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final QBean<InvoiceRedraftPageVO> pageList;

    public PagingVO<InvoiceRedraftPageVO> queryPaging(InvoiceRedraftQueryParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)this.qdo);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, this.qdo);
        jpaQuery.where(this.wherePage(paramVO));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    public void update(InvoiceRedraftDO invoiceRedraftDO) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())});
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getOrigApplyNo())) {
            update.set((Path)this.qdo.origApplyNo, (Object)invoiceRedraftDO.getOrigApplyNo());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getInvoiceNo())) {
            update.set((Path)this.qdo.invoiceNo, (Object)invoiceRedraftDO.getInvoiceNo());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getInvoiceAmt())) {
            update.set(this.qdo.invoiceAmt, (Object)invoiceRedraftDO.getInvoiceAmt());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getInvoiceDate())) {
            update.set(this.qdo.invoiceDate, (Object)invoiceRedraftDO.getInvoiceDate());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getInvoiceType())) {
            update.set((Path)this.qdo.invoiceType, (Object)invoiceRedraftDO.getInvoiceType());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getInvoiceDeduction())) {
            update.set(this.qdo.invoiceDeduction, (Object)invoiceRedraftDO.getInvoiceDeduction());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getRedraftReason())) {
            update.set((Path)this.qdo.redraftReason, (Object)invoiceRedraftDO.getRedraftReason());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getAttachmentId())) {
            update.set((Path)this.qdo.attachmentId, (Object)invoiceRedraftDO.getAttachmentId());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getWorkflowSubmitTime())) {
            update.set(this.qdo.workflowSubmitTime, (Object)invoiceRedraftDO.getWorkflowSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getWorkflowProcInstId())) {
            update.set((Path)this.qdo.workflowProcInstId, (Object)invoiceRedraftDO.getWorkflowProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRedraftDO.getWorkflowProcInstStatus())) {
            update.set(this.qdo.workflowProcInstStatus, (Object)invoiceRedraftDO.getWorkflowProcInstStatus());
        }
        update.execute();
    }

    private Predicate wherePage(InvoiceRedraftQueryParam query) {
        Predicate customFieldPredicate;
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!ObjectUtils.isEmpty((Object)query.getWorkflowProcInstStatus())) {
            predicates.add(this.qdo.workflowProcInstStatus.eq((Object)query.getWorkflowProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrigApplyNo())) {
            predicates.add(this.qdo.origApplyNo.like(SqlUtil.toSqlLikeString(query.getOrigApplyNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceNo())) {
            predicates.add(this.qdo.invoiceNo.like(SqlUtil.toSqlLikeString(query.getInvoiceNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceType())) {
            predicates.add(this.qdo.invoiceType.eq((Object)query.getInvoiceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceDateStart()) && !ObjectUtils.isEmpty((Object)query.getInvoiceDateEnd())) {
            predicates.add(this.qdo.invoiceDate.between((Comparable)query.getInvoiceDateStart(), (Comparable)query.getInvoiceDateEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)query.getInvoiceNo())) {
            predicates.add(this.qdo.invoiceNo.eq((Object)query.getInvoiceNo()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)query.getConditions(), InvoiceRedraftDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InvoiceRedraftPageVO> queryByInvoiceNoCreateTimeDesc(InvoiceRedraftQueryParam invoiceRedraftQueryParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)this.qdo);
        jpaQuery.where(this.wherePage(invoiceRedraftQueryParam));
        jpaQuery.orderBy(this.qdo.createTime.desc());
        return jpaQuery.fetch();
    }

    public InvoiceRedraftRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(InvoiceRedraftPageVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.origApplyNo, this.qdo.invoiceNo, this.qdo.serialNo, this.qdo.invoiceAmt, this.qdo.invoiceDate, this.qdo.invoiceType, this.qdo.invoiceDeduction, this.qdo.redraftReason, this.qdo.attachmentId, this.qdo.workflowProcInstStatus, this.qdo.workflowProcInstId, this.qdo.tenantId, this.qdo.remark, this.qdo.creator, this.qdo.createUserId, this.qdo.modifyUserId, this.qdo.createTime, this.qdo.modifyTime, this.qdo.deleteFlag, this.qdo.docStatus, this.qdo.extensionInfo});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

