package com.elitesland.fin.application.convert.invoice;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceApplyDetailRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceApplyRespVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.ApplySaveDTO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.order.param.SaleReconciliatDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/19
 */
@Mapper(config = BaseMapperConfig.class)
public interface InvoiceConvert {

    InvoiceConvert INSTANCE = Mappers.getMapper(InvoiceConvert.class);

    @Mapping(source = "details", target = "saleInvDtls")
    SaleInv toSaleInv(InvoiceApplySaveParam param);

    List<SaleInvdDtlDO> convertInvd(List<InvoiceSaveParam> param);

    InvoiceApplyRespVO toApplyRespVO(SaleInvVO res);

    @Mapping(source = "id", target = "applyId")
    InvoiceApplyRpcDTO doToDTO(SaleInvDO saleInvDO);

    List<InvoiceApplyDetailRespVO> detailToVO(List<SaleInvDtlVO> deatils);


    ApplySaveParam saveDTO2Param(ApplySaveDTO param);

    @Mapping(source = "saleReconciliatDtlDTOList", target = "invoiceAwaitDDTOList")
    List<InvoiceAwaitDTO> saleRecDTOs2AwaitDTOs(List<SaleReconciliatDTO> saleReconciliatDTOS);

    @Mapping(source = "saleReconciliatDtlDTOList", target = "invoiceAwaitDDTOList")
    InvoiceAwaitDTO saleRecDTO2AwaitDTO(SaleReconciliatDTO saleRec);

    InvoiceAwaitDO dto2Do(InvoiceAwaitDTO item);
}
