package com.elitesland.fin.infr.dto.invoice;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/11
 */
@Data
@ApiModel("开票规则配置分页")
public class InvoiceRuleConfigDTO extends BaseViewModel {

    @ApiModelProperty("适用单据 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDocCls;
    @ApiModelProperty("来源单据名称")
    private String optDocClsName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("启用状态名称")
    private String statusName;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String optDocType;
    @ApiModelProperty("来源单据类型名称")
    private String optDocTypeName;

    @ApiModelProperty("可开票单据状态 [UDC]yst-franchisee:PAYMENT_STATUS")
    @SysCode(sys = "yst-franchisee", mod = "PAYMENT_STATUS")
    private String optDocStatus;
    @ApiModelProperty("可开票单据状态名称")
    private String optDocStatusName;

    @ApiModelProperty("可开票时限（天）")
    private Integer invoiceLimit;

    @ApiModelProperty(value = "是否自动开票 1-是 0-否")
    private Integer autoInvoice;

    @ApiModelProperty(value = "开票是否自动审核 1-是 0-否")
    private Integer autoReview;

    @ApiModelProperty(value = "发票红冲前是否需要换开申请审核 1-是 0-否")
    private Integer needRedraft;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "是否允许修改发票抬头 1-是 0-否")
    private Integer editInvTitle;
}
