/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.arorder;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.domain.entity.arorder.ArOrderRecordDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderRecordDO;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ArOrderRecordRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderRecordDO qArOrderRecordDO = QArOrderRecordDO.arOrderRecordDO;

    public List<ArOrderRecordDO> selectArOrderRecordByParam(ArOrderRecordParam param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (CollectionUtil.isNotEmpty(param.getSourceDocTypeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.sourceDocType.in(param.getSourceDocTypeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getSourceDocStatusList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.sourceDocStatus.in(param.getSourceDocStatusList()));
        }
        if (CollectionUtil.isNotEmpty(param.getCreateModeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.createMode.in(param.getCreateModeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getSourceNoList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.sourceNo.in(param.getSourceNoList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.ouCode.in(param.getOuCodeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuIdList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.ouId.in(param.getOuIdList()));
        }
        if (CollectionUtil.isNotEmpty(param.getArFlagList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qArOrderRecordDO.arFlag.in(param.getArFlagList()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qArOrderRecordDO).from((EntityPath)this.qArOrderRecordDO)).where((Predicate)predicate)).fetch();
    }

    public void updateArFlagById(Long id, String arFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qArOrderRecordDO).set((Path)this.qArOrderRecordDO.arFlag, (Object)arFlag).where(new Predicate[]{this.qArOrderRecordDO.id.eq((Object)id)}).execute();
    }

    public void updateArFlagAndFailMsgById(Long id, String arFlag, String failMsg) {
        this.jpaQueryFactory.update((EntityPath)this.qArOrderRecordDO).set((Path)this.qArOrderRecordDO.arFlag, (Object)arFlag).set((Path)this.qArOrderRecordDO.failMsg, (Object)failMsg).where(new Predicate[]{this.qArOrderRecordDO.id.eq((Object)id)}).execute();
    }

    public void updateDeleteFlagById(List<Long> ids) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qArOrderRecordDO).set(this.qArOrderRecordDO.deleteFlag, (Object)1).where(new Predicate[]{this.qArOrderRecordDO.id.in(ids)});
        jpaUpdateClause.execute();
    }

    public void updateDeleteFlagBySourceNo(String sourceNo) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qArOrderRecordDO).set(this.qArOrderRecordDO.deleteFlag, (Object)1).where(new Predicate[]{this.qArOrderRecordDO.sourceNo.eq((Object)sourceNo)});
        jpaUpdateClause.execute();
    }

    public void updateDeleteFlagBySourceNos(List<String> sourceNos) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qArOrderRecordDO).set(this.qArOrderRecordDO.deleteFlag, (Object)1).where(new Predicate[]{this.qArOrderRecordDO.sourceNo.in(sourceNos)});
        jpaUpdateClause.execute();
    }

    public List<Long> selectIdBySourceNo(List<String> sourceNos) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderRecordDO.id).from((EntityPath)this.qArOrderRecordDO)).where((Predicate)this.qArOrderRecordDO.sourceNo.in(sourceNos))).fetch();
    }

    public ArOrderRecordRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

