/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.param.payorder.OrderAmtRpcParam;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PayOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;
    private final QPayOrderDtlDO qPayOrderDtlDO = QPayOrderDtlDO.payOrderDtlDO;

    public List<PayOrderDO> queryBySourceNo(String sourceNo) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPayOrderDO).where((Predicate)this.qPayOrderDO.sourceNo.eq((Object)sourceNo))).fetch();
    }

    public List<PayOrderDO> queryBySourceNoList(List<String> sourceNoList) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPayOrderDO).where((Predicate)this.qPayOrderDO.sourceNo.in(sourceNoList))).fetch();
    }

    public PayOrderDTO queryById(Long id) {
        return (PayOrderDTO)((JPAQuery)((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.id.eq((Object)id))).where((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0))).fetchOne();
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qPayOrderDO).where(new Predicate[]{this.qPayOrderDO.id.in(ids)}).execute();
    }

    public List<PayOrderDTO> queryByPayTypeId(List<Long> ids) {
        return ((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.payTypeId.in(ids))).fetch();
    }

    public Long audit(List<Long> ids, String auditRejection, SysUserDTO user) {
        return this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set(this.qPayOrderDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qPayOrderDO.auditRejection, (Object)auditRejection).set((Path)this.qPayOrderDO.auditUser, (Object)user.getUsername()).set(this.qPayOrderDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qPayOrderDO.id.in(ids)}).execute();
    }

    public List<PayOrderDTO> queryByParam(PayOrderParam payOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)payOrderParam.getCurrCode())) {
            predicates.add(this.qPayOrderDO.currCode.eq((Object)payOrderParam.getCurrCode()));
        }
        if (payOrderParam.getSuppId() != null) {
            predicates.add(this.qPayOrderDO.suppId.eq((Object)payOrderParam.getSuppId()));
        }
        if (payOrderParam.getOuId() != null) {
            predicates.add(this.qPayOrderDO.ouId.eq((Object)payOrderParam.getOuId()));
        }
        if (payOrderParam.getBuDateStart() != null && payOrderParam.getBuDateEnd() != null) {
            predicates.add(this.qPayOrderDO.buDate.between((Comparable)payOrderParam.getBuDateStart(), (Comparable)payOrderParam.getBuDateEnd()));
        }
        predicates.add(this.qPayOrderDO.deleteFlag.eq((Object)0));
        predicates.add(this.qPayOrderDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        return ((JPAQuery)this.select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<PayOrderDTO> selectPayOrderByParam(PayOrderParam payOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtil.isNotEmpty(payOrderParam.getPayOrderNoList())) {
            predicates.add(this.qPayOrderDO.payOrderNo.in(payOrderParam.getPayOrderNoList()));
        }
        return ((JPAQuery)this.select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<PayOrderDTO> queryByIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.id.in(ids))).where((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0))).fetch();
    }

    public PagingVO<PayOrderDTO> page(PayOrderPageParam param, List<Long> ids) {
        List<Predicate> predicates = this.pageWhere(param, ids);
        JPAQuery query = (JPAQuery)this.select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        BusinessSecurityUtil.where(query, PayOrderDO.class);
        param.setPaging(query);
        param.fillOrders(query, this.qPayOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private List<Predicate> pageWhere(PayOrderPageParam param, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (CollUtil.isNotEmpty(param.getInOutCustList())) {
            predicates.add((Predicate)this.qPayOrderDO.inOutCust.in(param.getInOutCustList()));
        }
        if (CollUtil.isNotEmpty(param.getRelevanceOuCodeList())) {
            predicates.add((Predicate)this.qPayOrderDO.relevanceOuCode.in(param.getRelevanceOuCodeList()));
        }
        if (param.getApFlag() != null) {
            predicates.add((Predicate)this.qPayOrderDO.apFlag.eq(param.getApFlag()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCreateMode())) {
            predicates.add((Predicate)this.qPayOrderDO.createMode.eq((Object)param.getCreateMode()));
        }
        if (param.getInitFlag() != null) {
            predicates.add((Predicate)this.qPayOrderDO.initFlag.eq(param.getInitFlag()));
        }
        if (param.getPayTypeId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.payTypeId.eq((Object)param.getPayTypeId()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getVerState())) {
            predicates.add((Predicate)this.qPayOrderDO.verState.eq((Object)param.getVerState()));
        }
        if (CollectionUtil.isNotEmpty(param.getVerStateList())) {
            predicates.add((Predicate)this.qPayOrderDO.verState.in(param.getVerStateList()));
        }
        if (Objects.nonNull(param.getRedState())) {
            predicates.add((Predicate)this.qPayOrderDO.redState.eq(param.getRedState()));
        }
        if (Objects.nonNull(param.getProposedStatus())) {
            predicates.add((Predicate)this.qPayOrderDO.proposedStatus.eq((Object)param.getProposedStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getRedSourceNo())) {
            predicates.add((Predicate)this.qPayOrderDO.redSourceNo.like("%" + param.getRedSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderState())) {
            predicates.add((Predicate)this.qPayOrderDO.orderState.eq((Object)param.getOrderState()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCurrCode())) {
            predicates.add((Predicate)this.qPayOrderDO.currCode.eq((Object)param.getCurrCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getSourceNo())) {
            predicates.add((Predicate)this.qPayOrderDO.sourceNo.like("%" + param.getSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getPayOrderNo())) {
            predicates.add((Predicate)this.qPayOrderDO.payOrderNo.like("%" + param.getPayOrderNo() + "%"));
        }
        if (param.getSuppId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.suppId.eq((Object)param.getSuppId()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOperator())) {
            predicates.add((Predicate)this.qPayOrderDO.operator.like("%" + param.getOperator() + "%"));
        }
        if (param.getOuId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.ouId.eq((Object)param.getOuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOuCode())) {
            predicates.add((Predicate)this.qPayOrderDO.ouCode.eq((Object)param.getOuCode()));
        }
        if (null != param.getBuDateStart() && null != param.getBuDateEnd()) {
            predicates.add((Predicate)this.qPayOrderDO.buDate.between((Comparable)param.getBuDateStart(), (Comparable)param.getBuDateEnd()));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add((Predicate)this.qPayOrderDO.id.in(ids));
        }
        if (!CollUtil.isEmpty(param.getIdList())) {
            predicates.add((Predicate)this.qPayOrderDO.id.in(param.getIdList()));
        }
        if (param.getTotalAmtFrom() != null) {
            predicates.add((Predicate)this.qPayOrderDO.totalAmt.goe((Number)param.getTotalAmtFrom()));
        }
        if (param.getTotalAmtTo() != null) {
            predicates.add((Predicate)this.qPayOrderDO.totalAmt.loe((Number)param.getTotalAmtTo()));
        }
        if (param.getOperUserId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.operUserId.eq((Object)param.getOperUserId()));
        }
        if (null != param.getApDateStart() && null != param.getApDateEnd()) {
            predicates.add((Predicate)this.qPayOrderDO.apDate.between((Comparable)param.getApDateStart(), (Comparable)param.getApDateEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getTransferStatus())) {
            predicates.add((Predicate)this.qPayOrderDO.transferStatus.eq((Object)param.getTransferStatus()));
        }
        if (param.getPayOuId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.payOuId.eq((Object)param.getPayOuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPayOuCode())) {
            predicates.add((Predicate)this.qPayOrderDO.payOuCode.eq((Object)param.getPayOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSyncStatus())) {
            predicates.add((Predicate)this.qPayOrderDO.syncStatus.eq((Object)param.getSyncStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getSyncStatusList())) {
            predicates.add((Predicate)this.qPayOrderDO.syncStatus.in(param.getSyncStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOutSysKey())) {
            predicates.add((Predicate)this.qPayOrderDO.outSysKey.eq((Object)param.getOutSysKey()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getTransNo())) {
            predicates.add((Predicate)this.qPayOrderDO.transNo.eq((Object)param.getTransNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRcvSeqNo())) {
            predicates.add((Predicate)this.qPayOrderDO.rcvSeqNo.eq((Object)param.getRcvSeqNo()));
        }
        predicates.add((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0));
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)param.getConditions(), PayOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppId, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouId, this.qPayOrderDO.ouName, this.qPayOrderDO.apTypeId, this.qPayOrderDO.apTypeCode, this.qPayOrderDO.apTypeName, this.qPayOrderDO.payTypeId, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.currCode, this.qPayOrderDO.currName, this.qPayOrderDO.operator, this.qPayOrderDO.operUserId, this.qPayOrderDO.buType, this.qPayOrderDO.buDate, this.qPayOrderDO.totalAmt, this.qPayOrderDO.totalCurAmt, this.qPayOrderDO.auditUserId, this.qPayOrderDO.auditDate, this.qPayOrderDO.auditUser, this.qPayOrderDO.orderState, this.qPayOrderDO.exchangeRate, this.qPayOrderDO.initFlag, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.realPayCurAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.apFlag, this.qPayOrderDO.createTime, this.qPayOrderDO.creator, this.qPayOrderDO.modifyTime, this.qPayOrderDO.updater, this.qPayOrderDO.remark, this.qPayOrderDO.auditRejection, this.qPayOrderDO.createMode, this.qPayOrderDO.localCurrCode, this.qPayOrderDO.localCurrName, this.qPayOrderDO.verState, this.qPayOrderDO.verAmt, this.qPayOrderDO.auditDataVersion, this.qPayOrderDO.procInstId, this.qPayOrderDO.procInstStatus, this.qPayOrderDO.approvedTime, this.qPayOrderDO.submitTime, this.qPayOrderDO.addrNo, this.qPayOrderDO.suppAddrNo, this.qPayOrderDO.redState, this.qPayOrderDO.redSourceId, this.qPayOrderDO.redSourceNo, this.qPayOrderDO.proposedStatus, this.qPayOrderDO.inOutCust, this.qPayOrderDO.relevanceOuCode, this.qPayOrderDO.extensionInfo, this.qPayOrderDO.transferStatus, this.qPayOrderDO.payOuId, this.qPayOrderDO.payOuCode, this.qPayOrderDO.payOuName, this.qPayOrderDO.payOuSameFlag, this.qPayOrderDO.syncStatus, this.qPayOrderDO.syncError, this.qPayOrderDO.outSysKey, this.qPayOrderDO.transNo, this.qPayOrderDO.rcvSeqNo})).from((EntityPath)this.qPayOrderDO);
    }

    public ApVerDTO queryVerAmtById(Long id) {
        return (ApVerDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ApVerDTO.class, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.totalAmt, this.qPayOrderDO.verAmt, this.qPayOrderDO.auditDataVersion})).from((EntityPath)this.qPayOrderDO)).where((Predicate)this.qPayOrderDO.id.eq((Object)id))).fetchOne();
    }

    public void updateVerApplyFlag(Long id, String val) {
        this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.verApplyFlag, (Object)val).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)}).execute();
    }

    public long updateVerAmt(ApVerDTO apVerDTO) {
        return this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.verState, (Object)apVerDTO.getVerState()).set(this.qPayOrderDO.verAmt, (Object)apVerDTO.getVerAmt()).set(this.qPayOrderDO.auditDataVersion, (Object)(apVerDTO.getAuditDataVersion() + 1)).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)apVerDTO.getId()).and((Predicate)this.qPayOrderDO.totalAmt.goe((Number)apVerDTO.getVerAmt())).and((Predicate)this.qPayOrderDO.auditDataVersion.eq((Object)apVerDTO.getAuditDataVersion()))}).execute();
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set(this.qPayOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qPayOrderDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qPayOrderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qPayOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).setNull((Path)this.qPayOrderDO.redState).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.redState, (Object)flag).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public PagingVO<PayOrderExportEntity> defaultExport(PayOrderPageParam param) {
        List<Predicate> predicates = this.pageWhere(param, null);
        Predicate predicate = ExpressionUtils.allOf(predicates);
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PayOrderExportEntity.class, (Expression[])new Expression[]{this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouName, this.qPayOrderDO.apTypeCode, this.qPayOrderDO.apTypeName, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.currCode, this.qPayOrderDO.currName, this.qPayOrderDO.operator, this.qPayOrderDO.buType, this.qPayOrderDO.buDate, this.qPayOrderDO.totalAmt, this.qPayOrderDO.totalCurAmt, this.qPayOrderDO.auditUserId, this.qPayOrderDO.auditDate, this.qPayOrderDO.auditUser, this.qPayOrderDO.orderState, this.qPayOrderDO.exchangeRate, this.qPayOrderDO.initFlag, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.realPayCurAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.apFlag, this.qPayOrderDO.createTime, this.qPayOrderDO.creator, this.qPayOrderDO.modifyTime, this.qPayOrderDO.updater, this.qPayOrderDO.remark, this.qPayOrderDO.auditRejection, this.qPayOrderDO.createMode, this.qPayOrderDO.localCurrCode, this.qPayOrderDO.localCurrName, this.qPayOrderDO.verState, this.qPayOrderDO.verAmt, this.qPayOrderDO.totalAmt.subtract(this.qPayOrderDO.verAmt).as("unVerAmt"), this.qPayOrderDO.approvedTime, this.qPayOrderDO.submitTime, this.qPayOrderDO.addrNo, this.qPayOrderDO.suppAddrNo, this.qPayOrderDO.redState, this.qPayOrderDO.redSourceNo, this.qPayOrderDO.proposedStatus})).from((EntityPath)this.qPayOrderDO)).where(predicate);
        param.setPaging(query);
        param.fillOrders(query, this.qPayOrderDO);
        return new PagingVO(query.fetchCount(), query.fetch());
    }

    public List<PayOrderDTO> selectInOutCustByPayOrderNo(List<String> payOrderNoList) {
        if (CollectionUtil.isEmpty(payOrderNoList)) {
            return Collections.EMPTY_LIST;
        }
        List payOrderDTOList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PayOrderDTO.class, (Expression[])new Expression[]{this.qPayOrderDO.payOrderNo, this.qPayOrderDO.inOutCust, this.qPayOrderDO.relevanceOuCode})).from((EntityPath)this.qPayOrderDO)).where((Predicate)this.qPayOrderDO.payOrderNo.in(payOrderNoList))).fetch();
        return payOrderDTOList;
    }

    public void updateVerState(String verState, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.verState, (Object)verState).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public Long countExportPayOrder(PayOrderPageParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qPayOrderDtlDO.count()).from((EntityPath)this.qPayOrderDtlDO)).leftJoin((EntityPath)this.qPayOrderDO)).on((Predicate)this.qPayOrderDtlDO.masId.eq(this.qPayOrderDO.id));
        List<Predicate> predicates = this.pageWhere(param, null);
        if (StrUtil.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            predicates.add((Predicate)this.qPayOrderDtlDO.sourceNo.eq((Object)param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qPayOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchCount();
    }

    public List<PayOrderExportEntity> exportPayOrder(PayOrderPageParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PayOrderExportEntity.class, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppId, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouId, this.qPayOrderDO.ouName, this.qPayOrderDO.apTypeId, this.qPayOrderDO.apTypeCode, this.qPayOrderDO.apTypeName, this.qPayOrderDO.payTypeId, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName.as("payTypeCodeName"), this.qPayOrderDO.payOrderNo, this.qPayOrderDO.currCode, this.qPayOrderDO.currName, this.qPayOrderDO.operator, this.qPayOrderDO.operUserId, this.qPayOrderDO.buType, this.qPayOrderDO.buDate, this.qPayOrderDO.totalAmt, this.qPayOrderDO.auditUserId, this.qPayOrderDO.auditDate, this.qPayOrderDO.auditUser, this.qPayOrderDO.orderState, this.qPayOrderDO.exchangeRate, this.qPayOrderDO.initFlag, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.apFlag, this.qPayOrderDO.createTime, this.qPayOrderDO.creator, this.qPayOrderDO.modifyTime, this.qPayOrderDO.updater, this.qPayOrderDO.remark, this.qPayOrderDO.auditRejection, this.qPayOrderDO.createMode, this.qPayOrderDO.auditDataVersion, this.qPayOrderDO.procInstId, this.qPayOrderDO.procInstStatus, this.qPayOrderDO.approvedTime, this.qPayOrderDO.submitTime, this.qPayOrderDO.addrNo, this.qPayOrderDO.suppAddrNo, this.qPayOrderDO.redState, this.qPayOrderDO.redSourceId, this.qPayOrderDO.redSourceNo, this.qPayOrderDO.proposedStatus, this.qPayOrderDO.inOutCust, this.qPayOrderDO.relevanceOuCode, this.qPayOrderDtlDO.sourceNo.as("detailSourceNo"), this.qPayOrderDtlDO.sourceLine, this.qPayOrderDtlDO.payType, this.qPayOrderDtlDO.payBank, this.qPayOrderDtlDO.payAccount, this.qPayOrderDtlDO.recBank, this.qPayOrderDtlDO.recAccount, this.qPayOrderDtlDO.totalAmt.as("detailTotalAmt"), this.qPayOrderDtlDO.realPayAmt.as("detailRealPayAmt"), this.qPayOrderDtlDO.verAmt, this.qPayOrderDtlDO.unVerAmt, this.qPayOrderDtlDO.applyVerAmTing})).from((EntityPath)this.qPayOrderDtlDO)).leftJoin((EntityPath)this.qPayOrderDO)).on((Predicate)this.qPayOrderDtlDO.masId.eq(this.qPayOrderDO.id));
        List<Predicate> predicates = this.pageWhere(param, null);
        if (StrUtil.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            predicates.add((Predicate)this.qPayOrderDtlDO.sourceNo.eq((Object)param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qPayOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        BusinessSecurityUtil.where(jpaQuery, PayOrderDO.class);
        param.setPaging(jpaQuery);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(new OrderSpecifier[]{this.qPayOrderDO.id.desc(), this.qPayOrderDtlDO.id.desc()});
        return jpaQuery.fetch();
    }

    public void updateSyncStatus(PayOrderDTO payOrderDTO) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO);
        update.set((Path)this.qPayOrderDO.syncStatus, (Object)payOrderDTO.getSyncStatus());
        update.set((Path)this.qPayOrderDO.syncError, (Object)payOrderDTO.getSyncError());
        update.set(this.qPayOrderDO.modifyTime, (Object)LocalDateTime.now());
        if (StringUtils.isNotEmpty((CharSequence)payOrderDTO.getOutSysKey())) {
            update.set((Path)this.qPayOrderDO.outSysKey, (Object)payOrderDTO.getOutSysKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)payOrderDTO.getTransNo())) {
            update.set((Path)this.qPayOrderDO.transNo, (Object)payOrderDTO.getTransNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)payOrderDTO.getRcvSeqNo())) {
            update.set((Path)this.qPayOrderDO.rcvSeqNo, (Object)payOrderDTO.getRcvSeqNo());
        }
        update.where(new Predicate[]{this.qPayOrderDO.id.eq((Object)payOrderDTO.getId())}).execute();
    }

    public List<PayOrderDTO> queryOrderAmt(OrderAmtRpcParam param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PayOrderDTO.class, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppId, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouId, this.qPayOrderDO.ouName, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.totalAmt, this.qPayOrderDO.totalCurAmt, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.realPayCurAmt})).from((EntityPath)this.qPayOrderDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (param.getOuId() != null) {
            predicates.add(this.qPayOrderDO.ouId.eq((Object)param.getOuId()));
        }
        if (param.getSuppId() != null) {
            predicates.add(this.qPayOrderDO.suppId.eq((Object)param.getSuppId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getFilterDocStatusList())) {
            predicates.add(this.qPayOrderDO.orderState.notIn((Collection)param.getFilterDocStatusList()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public PayOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

