package com.elitesland.fin.domain.param.recorder;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class RecOrderRpcExcelVO implements Serializable {
    private static final long serialVersionUID = -6799664794192598071L;
    @ExcelIgnore
    private Long id;
    @ColumnWidth(25)
    @ExcelProperty(index = 0, value = "收款单号")
    private String recOrderNo;
    @ColumnWidth(25)
    @ExcelProperty(index = 1, value = "加盟商编码")
    private String custCode;
    @ColumnWidth(25)
    @ExcelProperty(index = 2, value = "加盟商名称")
    private String custName;
    @ExcelIgnore
    @SysCode(sys = "yst-fin" ,mod = "REC_TYPE")
    private String recType;
    @ColumnWidth(25)
    @ExcelProperty(index = 3, value = "收款类型")
    private String recTypeName;
    @ColumnWidth(25)
    @ExcelProperty(index = 4, value = "门店编码")
    private String shopCode;
    @ColumnWidth(25)
    @ExcelProperty(index = 5, value = "门店名称")
    private String shopName;
    @NumberFormat("#.##")
    @ColumnWidth(25)
    @ExcelProperty(index = 6, value = "收款金额")
    private BigDecimal realRecAmt;
    @ApiModelProperty("收款状态")
    @SysCode(sys = "yst-fin",mod = "RECORDER_STATE")
    @ExcelIgnore
    private String orderState;
    @ColumnWidth(25)
    @ExcelProperty(index = 7, value = "收款状态")
    private String orderStateName;
    @ColumnWidth(25)
    @ExcelProperty(index = 8, value = "备注")
    private String remark;
    @ApiModelProperty("收款方式")
    @ExcelIgnore
    @SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String payMethod;
    @ColumnWidth(25)
    @ExcelProperty(index = 9, value = "收款方式")
    private String payMethodName;
    @ApiModelProperty("收款银行名称")
    @ColumnWidth(25)
    @ExcelProperty(index = 10, value = "收款银行")
    private String recBank;
    @ColumnWidth(25)
    @ExcelProperty(index = 11, value = "收款银行账户")
    @ApiModelProperty("收款银行账户")
    private String recAccount;
    @ColumnWidth(25)
    @ExcelProperty(index = 12, value = "收款流水")
    @ApiModelProperty("收款流水")
    private String recFlow;
    @NumberFormat("#.##")
    @ColumnWidth(25)
    @ExcelProperty(index = 13, value = "税额")
    @ApiModelProperty("税额")
    private BigDecimal totalAmt;
    @NumberFormat("#.##")
    @ColumnWidth(25)
    @ExcelProperty(index = 14, value = "税率")
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @NumberFormat("#.##")
    @ExcelProperty(index = 15, value = "明细收款金额")
    @ApiModelProperty("收款金额")
    private BigDecimal realRecAmtDetail;
    @ExcelProperty(index = 16, value = "币种")
    @ApiModelProperty("币种")
    private String currName;
    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-supp" ,mod = "DOC_CLS")
    @ExcelIgnore
    private String createMode;
    @ExcelProperty(index = 17, value = "单据来源")
    private String createModeName;
    @ExcelProperty(index = 18, value = "来源单号")
    @ApiModelProperty("来源单号")
    private String sourceNo;
}
