package com.elitesland.fin.provider.account;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountAppParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountAmtFlowVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.account.AccountAmtFlowRpcVO;
import com.elitesland.fin.dto.account.AccountRpcDTO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.fin.param.account.AccountRpcParam;
import com.elitesland.fin.service.account.AccountRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.account
 * @date 2023/3/7 14:00
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountRpcService.PATH)
@Slf4j
public class AccountRpcServiceImpl implements AccountRpcService {

    public final AccountService accountService;

    public final CreditAccountService creditAccountService;

    @Override
    public ApiResult<Void> createAccount(List<AccountRpcParam> param) {
        log.info("开始生成账户:{}", JSON.toJSONString(param));
        checkCreateAccountParam(param);

        buildAccountParam(param).stream().forEach(item -> {
            try {
                accountService.save(item);
            } catch (Exception e) {

            }
        });

        buildCreditAccountParam(param).stream().forEach(item -> {
            try {
                creditAccountService.saveOrUpdate(item);
            } catch (Exception e) {

            }
        });

        return ApiResult.ok();
    }


    private List<AccountSaveParam> buildAccountParam(List<AccountRpcParam> param) {

        List<AccountSaveParam> accountParamList = param.stream()
                .filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) ||
                        UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()))
                .map(item -> {
                    AccountSaveParam accountSaveParam = new AccountSaveParam();

                    accountSaveParam.setSecOuCode(item.getOuCode());
                    accountSaveParam.setAccountHolderName(item.getObjectName());
                    accountSaveParam.setAccountType(item.getAccountType());
                    accountSaveParam.setAccountHolderCode(item.getObjectCode());
                    accountSaveParam.setAccountName(item.getAccountName());
                    accountSaveParam.setAccountHolderType(item.getObjectType());
                    accountSaveParam.setAccountAmount(BigDecimal.ZERO);
                    accountSaveParam.setAccountOccupancyAmount(BigDecimal.ZERO);
                    accountSaveParam.setAccountAvailableAmount(BigDecimal.ZERO);

                    return accountSaveParam;
                }).collect(Collectors.toList());

        return accountParamList;
    }

    private List<CreditAccountSaveParam> buildCreditAccountParam(List<AccountRpcParam> param) {

        List<CreditAccountSaveParam> creditAccountSaveParamList = param.stream()
                .filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()))
                .map(item -> {
                    CreditAccountSaveParam creditAccountSaveParam = new CreditAccountSaveParam();
                    creditAccountSaveParam.setMark(item.getMark());
                    creditAccountSaveParam.setOuCode(item.getOuCode());
                    creditAccountSaveParam.setOuName(item.getOuName());
                    creditAccountSaveParam.setObjectType(item.getObjectType());
                    creditAccountSaveParam.setObjectName(item.getObjectName());
                    creditAccountSaveParam.setObjectCode(item.getObjectCode());
                    creditAccountSaveParam.setCreditAccountType(item.getAccountType());
                    creditAccountSaveParam.setCreditAccountName(item.getAccountName());

                    return creditAccountSaveParam;
                }).collect(Collectors.toList());

        return creditAccountSaveParamList;
    }


    void checkCreateAccountParam(List<AccountRpcParam> accountRpcParamList) {
        Assert.notEmpty(accountRpcParamList, "参数不能为空");
        accountRpcParamList.stream().forEach(item -> {
            Assert.notEmpty(item.getAccountType(), "账户类型为空");
            Assert.isTrue(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) ||
                    UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) ||
                    UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()), "账户类型错误");
        });
    }

    @Override
    public ApiResult<List<AccountRpcDTO>> queryAccount(AccountRpcParam accountRpcParam) {
        AccountParam accountParam = new AccountParam();
        accountParam.setSecOuCode(accountRpcParam.getOuCode());
        accountParam.setAccountHolderName(accountRpcParam.getObjectName());
        accountParam.setAccountType(accountRpcParam.getAccountType());
        accountParam.setAccountHolderCode(accountRpcParam.getObjectCode());
        accountParam.setAccountName(accountRpcParam.getAccountName());
        accountParam.setAccountHolderType(accountRpcParam.getObjectType());
        List<AccountDTO> accountDTOS = accountService.getAccountByAccountParam(accountParam);
        return ApiResult.ok(AccountConvert.INSTANCE.dtos2RpcDtos(accountDTOS));
    }

    @Override
    public ApiResult<AccountAmtFlowRpcVO> selectAccountAmtAndFlow(AccountAppRpcParam accountAppRpcParam) {
        AccountAppParam accountAppParam =  AccountConvert.INSTANCE.rpcParamToParam(accountAppRpcParam);
        AccountAmtFlowVO accountAmtFlowVO = accountService.selectAccountAmtAndFlow(accountAppParam);
        return ApiResult.ok(AccountConvert.INSTANCE.folwToRpcFlow(accountAmtFlowVO));
    }

}
