package com.elitesland.fin.application.facade.param.limitadjustorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:47
 */
@Data
@ApiModel(description = "调整单")
public class LimitAdjustOrderSaveParam extends CustomFieldBaseModelVo {
    private List<Long> ids;

    @ApiModelProperty("单号")
    private String docNo;
    @ApiModelProperty("单号集合")
    private List<String> docNoList;

    @ApiModelProperty("单据状态")
    private String docState;
    @ApiModelProperty("单据状态集合")
    private List<String> docStateList;
    @ApiModelProperty("授信类型")
    private String creditType;
    @ApiModelProperty("授信类型集合")
    private List<String> creditTypeList;
    @ApiModelProperty("调整类型")
    private String adjustType;
    @ApiModelProperty("调整类型集合")
    private List<String> adjustTypeList;
    @ApiModelProperty("效期至")
    private LocalDateTime expireTime;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("产品线")
    private String productLine;

    @ApiModelProperty("业务员")
    private String saleUser;

    @ApiModelProperty("对象类型 客户/客户组")
    private String objectType;

    @ApiModelProperty("对象名称 客户/客户组名称")
    private String objectName;
    @ApiModelProperty("对象名称 客户/客户组名称集合")
    private List<String> objectNameList;

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;
    @ApiModelProperty("信用账户编码集合")
    private List<String> creditAccountCodeList;
    @ApiModelProperty("信用账户名称")
    private String creditAccountName;
    @ApiModelProperty("信用账户名称集合")
    private List<String> creditAccountNameList;
    @ApiModelProperty("调整额度")
    private BigDecimal adjustLimit;

    @ApiModelProperty("调整原因")
    private String adjustReason;
    @ApiModelProperty("调整原因集合")
    private List<String> adjustReasonList;
    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("创建日期/开始")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建日期/结束")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditTimeStart;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditTimeEnd;

    @ApiModelProperty("现在的时间")
    private LocalDateTime currentTime;

    @ApiModelProperty("附件编码")
    private String fileCode;

    @ApiModelProperty("效期起")
    private LocalDateTime effectiveTime;

    @ApiModelProperty("当前生效时间")
    private LocalDateTime currEffectiveTime;
}
