package com.elitesland.fin.application.service.arorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDtlDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderExcelDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.arorder
 * @date 2022/4/13 14:13
 */
@Service
@RequiredArgsConstructor
public class ArOrderDtlServiceImpl implements ArOrderDtlService {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlDomainService arOrderDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ArOrderDtlVO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlDTO> page = arOrderDtlDomainService.page(arOrderDtlPageParam);
        return ArOrderDtlConvert.INSTANCE.convertPage(page);
    }

    @Override
    @SysCodeProc
    public PagingVO<ArOrderExcelDTO> exportArOrder(ArOrderPageParam arOrderPageParam) {
        Long count = arOrderDtlRepoProc.countExportArOrder(arOrderPageParam);
        if (count > 0) {
            List<ArOrderExcelDTO> arListExportEntities = arOrderDtlRepoProc.exportArOrder(arOrderPageParam);
            return new PagingVO<>(count, arListExportEntities);
        }
        return new PagingVO<>();
    }
}
