package com.elitesland.fin.entity.invoice;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2023/8/3
 */
@Entity
@Table(name = "fin_payment_charges", indexes = {
        @Index(name = "idx_store_rule_code",columnList = "store_code,fee_rule_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "fin_payment_charges", comment = "费用记录表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "费用记录表", description = "费用记录表")
@Where(clause = "delete_flag = 0")
public class PaymentChargesDO extends BaseModel implements Serializable {

    @Column(name = "franchisee_id", columnDefinition = "bigint(20) comment '加盟商ID'")
    private Long franchiseeId;

    @Column(name = "store_code", columnDefinition = "varchar(32) comment '门店编码'")
    private String storeCode;

    @Column(name = "store_name", columnDefinition = "varchar(255) comment '门店名称'")
    private String storeName;

    @Column(name = "fee_rule_code", columnDefinition = "varchar(64) comment '收费规则编码'")
    private String feeRuleCode;

    @Column(name = "fee_rule_Name", columnDefinition = "varchar(255) comment '收费规则名称'")
    private String feeRuleName;

    @Column(name = "total_charges_amt", columnDefinition = "DECIMAL(20,6) comment '费用金额'")
    private BigDecimal totalChargesAmt;

    @Column(name = "charges_percent", columnDefinition = "DECIMAL(20,6) comment '费用收取比例'")
    private BigDecimal chargesPercent;

}
