package com.elitesland.fin.entity.invoice;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "fin_payment_records")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_records", comment = "付款记录表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "付款记录表", description = "付款记录表")
@Where(clause = "delete_flag = 0")
public class PaymentRecordsDO extends BaseModel implements Serializable {

    @Column(name = "doc_no", columnDefinition = "varchar(64) comment '付款记录单号'")
    private String docNo;

    @Column(name = "notice_id", columnDefinition = "bigint(20) comment '付款通知ID'")
    private Long noticeId;
    /**
     * 加盟商ID
     */
    @Column(name = "franchisee_id", columnDefinition = "bigint(20) comment '加盟商ID'")
    private Long franchiseeId;

    @Column(name = "payment_status", columnDefinition = "varchar(64) comment '付款状态'")
    private String paymentStatus;

    /**
     * 公司ID
     */
    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;
    /**
     * 公司编码
     */
    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;
    /**
     * 公司名称
     */
    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;
    /**
     * 开户银行
     */
    @Column(name = "inv_bank_no", columnDefinition = "varchar(100) comment '开户银行'")
    private String invBankNo;
    /**
     * 银行账号
     */
    @Column(name = "bank_account", columnDefinition = "varchar(100) comment '银行账号'")
    private String bankAccount;
    /**
     * 税率
     */
    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,6) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,6) comment '含税金额'")
    private BigDecimal amt;
    /**
     * 日期
     */
    @Column(name = "notice_date", columnDefinition = "dateTime comment '日期'")
    private LocalDate noticeDate;

    @Column(name = "payment_date", columnDefinition = "dateTime comment '付款日期'")
    private LocalDate paymentDate;
    /**
     * 通知内容
     */
    @Column(name = "notice_content", columnDefinition = "varchar(255) comment '通知内容'")
    private String noticeContent;

    @Column(name = "voucher_file_code", columnDefinition = "varchar(255) comment '支付凭证文件编码'")
    private String voucherFileCode;

    @Column(name = "uni_bank_no", columnDefinition = "varchar(125) comment '联行号'")
    private String uniBankNo;

    @Comment(value = "门店编码")
    @Column()
    private String storeCode;

    @Column(name = "store_name", columnDefinition = "varchar(255) comment '门店名称'")
    private String storeName;

    @Comment(value = "来源单据类型")
    @Column()
    private String sourceDocType;

    @Comment(value = "来源单据ID")
    @Column()
    private Long sourceDocId;

    @Comment(value = "来源单据单号")
    @Column()
    private String sourceDocNo;


    @Column(name = "receipt_id", columnDefinition = "bigint(20) comment '收款单ID'")
    private Long receiptId;

    @Column(name = "real_rec_amt", columnDefinition = "DECIMAL(20,6) comment '实收金额'")
    private BigDecimal realRecAmt;

    @Comment(value = "开票详情")
    @Column()
    private String invoiceInfo;
    @Column(name = "associate_number", columnDefinition = "varchar(64) comment '关联收款单号'")
    private String associateNumber;
    @Comment(value = "付款银行")
    @Column()
    private String payBank;
    @Comment(value = "付款账户")
    @Column()
    private String payAccount;
    @Comment(value = "付款类型")
    @Column()
    private String payType;

    @Column(name = "hidden_flag", columnDefinition = "tinyint(1) default '0' comment '是否显示'")
    private Boolean hiddenFlag;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(64) comment '客户姓名'")
    private String custName;
}
