package com.elitesland.fin.provider.expense;

import cn.hutool.json.JSONUtil;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.expense.ExpLedgerConvert;
import com.elitesland.fin.application.service.expense.ExpenseLedgerService;
import com.elitesland.fin.param.expense.ExpLedgerSaveRpcParam;
import com.elitesland.fin.service.expense.ExpenseLedgerRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/30 09:43
 * @Description:
 */
@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + ExpenseLedgerRpcService.PATH)
public class ExpenseLedgerRpcServiceImpl implements ExpenseLedgerRpcService {
    private final ExpenseLedgerService expenseLedgerService;

    @Override
    public void createExpenseLedger(ExpLedgerSaveRpcParam expLedgerSaveRpcParam) {
        log.info("生成费用计算台账RPC参数:{}", JSONUtil.toJsonStr(expLedgerSaveRpcParam));
        expenseLedgerService.save(ExpLedgerConvert.INSTANCE.rpcSave2SaveParam(expLedgerSaveRpcParam));
    }

    @Override
    public void createExpenseLedgerBatch(List<ExpLedgerSaveRpcParam> expLedgerSaveRpcParamList) {
        log.info("批量生成费用计算台账RPC参数:{}", JSONUtil.toJsonStr(expLedgerSaveRpcParamList));
        expenseLedgerService.save(ExpLedgerConvert.INSTANCE.rpcSave2SaveParamBatch(expLedgerSaveRpcParamList));
    }
}
