/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeDtlConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDtlDomainService;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgingRangeDtlDomainServiceImpl
implements AgingRangeDtlDomainService {
    private final AgingRangeDtlRepo agingRangeDtlRepo;
    private final AgingRangeDtlRepoProc agingRangeDtlRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> saveDtl(List<AgingRangeDtlSaveParam> saveParamList) {
        List dtlDOList = saveParamList.stream().map(AgingRangeDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        return this.agingRangeDtlRepo.saveAll(dtlDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.agingRangeDtlRepo.deleteByMasId(masId);
    }

    @Override
    @SysCodeProc
    public List<AgingRangeDtlVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.EMPTY_LIST;
        }
        AgingRangeDtlPageParam queryVO = new AgingRangeDtlPageParam();
        queryVO.setMasId(masId);
        List<AgingRangeDtlVO> dtlVOList = this.agingRangeDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    @Override
    @SysCodeProc
    public List<AgingRangeDtlVO> selectByParam(AgingRangeDtlPageParam queryVO) {
        List<AgingRangeDtlVO> dtlVOList = this.agingRangeDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        this.agingRangeDtlRepoProc.updateDeleteFlagBatch(deleteFlag, masIds);
    }

    public AgingRangeDtlDomainServiceImpl(AgingRangeDtlRepo agingRangeDtlRepo, AgingRangeDtlRepoProc agingRangeDtlRepoProc) {
        this.agingRangeDtlRepo = agingRangeDtlRepo;
        this.agingRangeDtlRepoProc = agingRangeDtlRepoProc;
    }
}

