package com.elitesland.fin.domain.entity.arorder;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收单主表扩展表
 * @author lucan.liu
 * @date 2023/9/3
 */
@Data
@Entity
@Table(name = "ar_order_ext")
@DynamicInsert
@DynamicUpdate
@Comment("应收单主表扩展表")
public class ArOrderExDo extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5577704836331720581L;

    @ApiModelProperty("订单客户")
    @Column(name = "order_customer", columnDefinition = "varchar(32)  comment '订单客户'")
    private String orderCustomer;

    @ApiModelProperty("应收单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '应收单主表关联id'")
    private Long relateId;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("开票日期")
    @Column(name = "inv_date", columnDefinition = "datetime(6)  comment '开票日期'")
    private LocalDateTime invDate;

    @ApiModelProperty("发票类型")
    @Column(name = "inv_type", columnDefinition = "varchar(32)  comment '发票类型'")
    private String invType;

    @ApiModelProperty("起算日期")
    @Column(name = "start_date", columnDefinition = "datetime(6)  comment '起算日期'")
    private LocalDateTime startDate;

    @ApiModelProperty("红冲标志")
    @Column(name = "red_flush_sign", columnDefinition = "tinyint(1)  comment '红冲标志'")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    @Column(name = "third_payment_assistance", columnDefinition = "varchar(32)  comment '第三方支付辅助'")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    @Column(name = "consumer_card_ssistance", columnDefinition = "varchar(32)  comment '消费卡辅助'")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    @Column(name = "credit_card_assistance", columnDefinition = "varchar(32)  comment '信用卡辅助'")
    private String creditCardAssistance;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "apply_ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmting;


}
