package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangePageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
public interface AgingRangeDomainService {

    /**
     * 账龄区间保存
     *
     * @param saveParam 入参
     * @return账龄区间ID
     */
    Long save(AgingRangeSaveParam saveParam);

    /**
     * 账龄区间分页查询
     *
     * @param pageParam 入参
     * @return 账龄区间信息集合
     */
    PagingVO<AgingRangePagingVO> page(AgingRangePageParam pageParam);

    /**
     * 根据ID查询主表数据
     *
     * @param id 账龄区间ID
     * @return 账龄区间主表数据
     */
    AgingRangeVO findById(Long id);

    /**
     * 根据账龄区间ID查询账龄区间主表数据
     *
     * @param id 账龄区间ID
     * @return 账龄区间主表数据
     */
    AgingRangeVO selectById(Long id);

    /**
     * 根据账龄区间编码查询账龄区间主表数据
     *
     * @param code 根据账龄区间编码
     * @return 账龄区间主表数据
     */
    AgingRangeVO selectByCode(String code);

    /**
     * 根据入参查询账龄区间数据
     *
     * @param queryVO 入参
     * @return 账龄区间主表数据
     */
    List<AgingRangeVO> selectByParam(AgingRangePageParam queryVO);

    /**
     * 校验查询编号/名称是否已经存在
     *
     * @param queryVO 入参
     * @return 账龄区间主表数据
     */
    AgingRangeVO checkSelectByParam(AgingRangePageParam queryVO);

    /**
     * 根据ID批量更新状态
     *
     * @param status 状态
     * @param ids    ID集合
     * @return
     */
    void updateStatusBatch(String status, List<Long> ids);

    /**
     * 根据ID更新状态
     *
     * @param status 状态
     * @param id     ID
     * @return
     */
    void updateStatusById(String status, Long id);

    /**
     * 根据ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param ids        主表ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids);

}
