package com.elitesland.fin.entity.account;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 * @desc : 账户快照表
 */
@Entity
@Table(name = "account_snapshot")
@org.hibernate.annotations.Table(appliesTo = "account_snapshot", comment = "账户快照表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountSnapshotDO extends CustomFieldBaseModel {

    @Column(name = "sec_ou_code", columnDefinition = "varchar(32) comment '归属公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String secOuCode;

    @Column(name = "sec_ou_name", columnDefinition = "varchar(32) comment '归属公司名称'")
    private String secOuName;

    @Column(name = "account_holder_name", columnDefinition = "varchar(32) comment '开户主体名称'")
    private String accountHolderName;

    @Column(name = "account_holder_code", columnDefinition = "varchar(32) comment '开户主体编码'")
    private String accountHolderCode;

    @Column(name = "account_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accountCode;

    @Column(name = "account_name", columnDefinition = "varchar(32) comment '账户名称'")
    private String accountName;

    @Column(name = "account_type", columnDefinition = "varchar(32) comment '账户类型'")
    private String accountType;

    @Column(name = "account_amount", columnDefinition = "decimal(18,8) comment '账户金额'")
    private BigDecimal accountAmount;

    @Column(name = "account_occupancy_amount", columnDefinition = "decimal(18,8) comment '账户占用金额'")
    private BigDecimal accountOccupancyAmount;

    @Column(name = "account_available_amount", columnDefinition = "decimal(18,8) comment '账户可用金额'")
    private BigDecimal accountAvailableAmount;

    @Column(name = "state", columnDefinition = "varchar(32) comment '状态'")
    private String state;

    @ApiModelProperty("快照时间")
    @Column(name = "snapshot_time", columnDefinition = "datetime(6) comment '快照时间'")
    private LocalDateTime snapshotTime;

}