package com.elitesland.fin.infr.repo.paymentperiod;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.entity.paymentperiod.QReceiptPaymentAgreementDO;
import com.elitesland.fin.infr.dto.paymentperiod.ReceiptPaymentAgreementDTO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ReceiptPaymentAgreementRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QReceiptPaymentAgreementDO qReceiptPaymentAgreementDO = QReceiptPaymentAgreementDO.receiptPaymentAgreementDO;

    public PagingVO<ReceiptPaymentAgreementPagingVO> page(ReceiptPaymentAgreementPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ReceiptPaymentAgreementPagingVO> query = select(ReceiptPaymentAgreementPagingVO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qReceiptPaymentAgreementDO);
        return PagingVO.<ReceiptPaymentAgreementPagingVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<ReceiptPaymentAgreementVO> selectListByParam(ReceiptPaymentAgreementPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ReceiptPaymentAgreementVO> query = select(ReceiptPaymentAgreementVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    public ReceiptPaymentAgreementVO checkSelectByParam(ReceiptPaymentAgreementPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ReceiptPaymentAgreementVO> jpaQuery = select(ReceiptPaymentAgreementVO.class).where(ExpressionUtils.allOf(where));

        return jpaQuery.fetchFirst();
    }

    private List<Predicate> where(ReceiptPaymentAgreementPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();



        if (!StringUtils.isEmpty(pageParam.getProtocolType())) {
            predicates.add(qReceiptPaymentAgreementDO.protocolType.eq(pageParam.getProtocolType()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getProtocolTypeList())){
            predicates.add(qReceiptPaymentAgreementDO.protocolType.in(pageParam.getProtocolTypeList()));
        }
        if (!StringUtils.isEmpty(pageParam.getProtocolCode())) {
            predicates.add(qReceiptPaymentAgreementDO.protocolCode.eq(pageParam.getProtocolCode()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getProtocolCodeList())){
            predicates.add(qReceiptPaymentAgreementDO.protocolCode.in(pageParam.getProtocolCodeList()));
        }

        if (!StringUtils.isEmpty(pageParam.getProtocolName())) {
            predicates.add(qReceiptPaymentAgreementDO.protocolName.eq(pageParam.getProtocolName()));
        }
        if (!StringUtils.isEmpty(pageParam.getProtocolNameKeyword())) {
            predicates.add(qReceiptPaymentAgreementDO.protocolName.like("%" + pageParam.getProtocolNameKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getGroupKeyword())) {
            predicates.add(qReceiptPaymentAgreementDO.protocolCode.like("%" + pageParam.getGroupKeyword() + "%").or(qReceiptPaymentAgreementDO.protocolName.like("%" + pageParam.getGroupKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(pageParam.getStatus())) {
            predicates.add(qReceiptPaymentAgreementDO.status.eq(pageParam.getStatus()));
        }
        if(CollectionUtils.isNotEmpty(pageParam.getStatusList())){
            predicates.add(qReceiptPaymentAgreementDO.status.in(pageParam.getStatusList()));
        }


        if (Objects.nonNull(pageParam.getId())){
            predicates.add(qReceiptPaymentAgreementDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qReceiptPaymentAgreementDO.id.in(pageParam.getIdList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qReceiptPaymentAgreementDO.id,
                qReceiptPaymentAgreementDO.protocolType,
                qReceiptPaymentAgreementDO.protocolCode,
                qReceiptPaymentAgreementDO.protocolName,
                qReceiptPaymentAgreementDO.status,
                qReceiptPaymentAgreementDO.remark,
                qReceiptPaymentAgreementDO.createTime,
                qReceiptPaymentAgreementDO.createUserId,
                qReceiptPaymentAgreementDO.creator,
                qReceiptPaymentAgreementDO.modifyTime,
                qReceiptPaymentAgreementDO.modifyUserId,
                qReceiptPaymentAgreementDO.updater,
                qReceiptPaymentAgreementDO.deleteFlag
        )).from(qReceiptPaymentAgreementDO);
    }


    public void updateStatusBatch(String status, List<Long> ids) {
        jpaQueryFactory.update(qReceiptPaymentAgreementDO)
                .set(qReceiptPaymentAgreementDO.status, status)
                .where(qReceiptPaymentAgreementDO.id.in(ids))
                .execute();
    }

    public void updateStatusById(String status, Long id) {
        jpaQueryFactory.update(qReceiptPaymentAgreementDO)
                .set(qReceiptPaymentAgreementDO.status, status)
                .where(qReceiptPaymentAgreementDO.id.eq(id))
                .execute();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qReceiptPaymentAgreementDO)
                .set(qReceiptPaymentAgreementDO.deleteFlag, deleteFlag)
                .where(qReceiptPaymentAgreementDO.id.in(ids))
                .execute();
    }

}
