package com.elitesland.fin.provider.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.service.aptype.ApTypeService;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.dto.recorder.RecOrderRpcDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.param.recorder.RecOrderRpcPageParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.param.recorder.WeChatPayRecOrderRpcParam;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgStoreRpcServiceService;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import com.elitesland.fin.utils.BigDecimalUtil;
import com.elitesland.inv.dto.companyAndCust.CompanyAndCustRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroDRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.dto.pay.TroPayRpcDTO;
import com.elitesland.inv.provider.InvCompanyAndCustProvider;
import com.elitesland.inv.provider.InvTroProvider;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.inv.provider.TroPayProvider;
import com.elitesland.pur.dto.PoPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoDDTO;
import com.elitesland.pur.dto.po.PurPoDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PoPayProvider;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.recorder
 * @date 2022/5/19 10:14
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + RecOrderRpcService.PATH)
public class RecOrderRpcServiceImpl implements RecOrderRpcService {

    private final PayTypeService payTypeService;
    private final RecTypeDomainService recTypeDomainService;
    public final RecOrderDomainService recOrderDomainService;
    public final RecOrderRpcTwoService recOrderRpcTwoService;
    private final ApTypeService apTypeService;
    private final InvCompanyAndCustProvider invCompanyAndCustProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final InvTroProvider invTroProvider;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService;
    private final RecOrderService recOrderService;
    private final TransactionTemplate transactionTemplate;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final PayOrderRepoProc payOrderRepoProc;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final PayOrderService payOrderService;
    private final PaymentRuleConfigService paymentRuleConfigService;
    @PersistenceContext
    private EntityManager entityManager;
    private final TroPayProvider troPayProvider;
    private final PoPayProvider poPayProvider;
    private final PurPoProvider purPoProvider;
    private final InvWhProvider invWhProvider;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final TaskExecutor taskExecutor;

    @Autowired
    private SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;


    @Override
    public Long save(RecOrderRpcParam recOrderRpcParam) {
        if (CharSequenceUtil.isBlank(recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        recOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = recOrderDomainService.save(recOrder);
        return resId;
    }

    @Override
    public ApiResult<PagingVO<RecOrderRpcDTO>> page(RecOrderRpcPageParam recOrderRpcPageParam) {

        PagingVO<RecOrderRpcPageRespVo> recOrderRpcPageRespVoPagingVO = recOrderRpcTwoService
                .queryRecOrderRpcPageList(RecOrderConvert.INSTANCE.recOrderRpcPageParam2RecOrderRpcTwoParam(recOrderRpcPageParam));

        return ApiResult.ok(RecOrderConvert.INSTANCE.recOrderRpcPageRespVoPagingVO2RecOrderRpcDTOPagingVO(recOrderRpcPageRespVoPagingVO));


    }

    @Override
    public Long wechatPay(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam) {
        Long resId;
        log.info("微企付生成收款单:weChatPayRecOrderRpcParam:{}", JSONUtil.toJsonStr(weChatPayRecOrderRpcParam));
        String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();
        //重复性校验
        try {
            checkIfExist(sourceNo);
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        Map<String, Long> docIdMap = new HashMap<>();
        Map<Long, BigDecimal> receiptAmtMap = new HashMap<>();
        //根据来源单据获取单据信息
        RecOrderSaveParam param = null;
        try {
            param = getRecOrderSaveParam(weChatPayRecOrderRpcParam, docIdMap, receiptAmtMap);
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        log.info("单据号:{},receiptAmtMap:{}", JSONUtil.toJsonStr(docIdMap), JSONUtil.toJsonStr(receiptAmtMap));
        Long docId = docIdMap.get("docId");
        Map<String, Set<Long>> paymentRuleIdsMap = new HashMap<>();
       /* resId = recOrderService.save(param).getData();
        entityManager.flush();
        entityManager.clear();
        String recOrderNo = recOrderService.queryById(resId).getRecOrderNo();*/
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        RecOrderSaveParam finalParam = param;
        resId = transactionTemplate.execute(trans -> {
            Long id = null;
            try {
                id = recOrderService.save(finalParam).getData();
                entityManager.flush();
                entityManager.clear();
                String recOrderNo = recOrderService.queryById(id).getRecOrderNo();
                log.info("已经完成收款单创建:{},收款单号:{}", JSONUtil.toJsonStr(finalParam), recOrderNo);

                //生成付款单
                RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(id);
                List<RecOrderDtlDTO> recOrderDtlDTOS = recOrderDtlRepoProc.queryByMasId(id);
                PayOrderSaveParam payOrderSaveParam = getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                payOrderService.save(payOrderSaveParam);
                log.info("已经完成付款单创建");

                //开始为对应储值账户生成账户流水
                Set<Long> paymentRuleIds = generateStoreAccountFlow(finalParam, recOrderNo, id);
                paymentRuleIdsMap.put("paymentRuleIds", paymentRuleIds);
            } catch (Exception e) {
                log.error("保存收款单生成流水发生错误:{}", e.getMessage(), e);
                sendWechatBoot(sourceNo, e.getMessage());
                trans.setRollbackOnly();
            }
            return id;
        });

        //调用支付
        log.info("支付规则id字典:{}", JSONUtil.toJsonStr(paymentRuleIdsMap));
        try {
            Set<Long> paymentRuleIds = paymentRuleIdsMap.get("paymentRuleIds");
            BigDecimal receiptAmt = receiptAmtMap.getOrDefault(docId, BigDecimal.ZERO);
            if (sourceNo.startsWith("PO")) {
                PoPayRpcDTO poPayRpcDTO = new PoPayRpcDTO();
                poPayRpcDTO.setId(docId);
                poPayRpcDTO.setDocNo(sourceNo);
                poPayRpcDTO.setReceiptAmt(receiptAmt);
                poPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                log.info("调用采购订单支付,参数:{}", JSONUtil.toJsonStr(poPayRpcDTO));
                poPayProvider.pay(poPayRpcDTO);
            } else { //调拨订单支付
                try {
                    TroPayRpcDTO troPayRpcDTO = new TroPayRpcDTO();
                    troPayRpcDTO.setId(docId);
                    troPayRpcDTO.setDocNo(sourceNo);
                    troPayRpcDTO.setReceiptAmt(receiptAmt);
                    troPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                    log.info("调用调拨订单支付,参数:{}", JSONUtil.toJsonStr(troPayRpcDTO));
                    troPayProvider.pay(troPayRpcDTO);
                } catch (Exception e) {
                    log.warn("调用调拨订单支付异常:{}", e.getMessage(), e);
                    throw new com.elitescloud.boot.exception.BusinessException("调用调拨订单支付异常:" + e.getMessage(), e);
                }
            }
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        log.info("调用调拨订单支付完成");
       
        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(resId);
        log.info("微企付生成收款单审批通过，开始自动核销:{}", JSONUtil.toJsonStr(recOrderDTO));
        CompletableFuture.runAsync(
                () -> {
                    finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
                }
                , taskExecutor);
        log.info("微企付返回");
        return resId;
    }

    @Override
    public Long lklPay(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam) {
        Long resId;
        log.info("拉卡拉生成收款单:weChatPayRecOrderRpcParam:{}", JSONUtil.toJsonStr(weChatPayRecOrderRpcParam));
        String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();
        //重复性校验
        try {
            checkIfExist(sourceNo);
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        Map<String, Long> docIdMap = new HashMap<>();
        Map<Long, BigDecimal> receiptAmtMap = new HashMap<>();
        //根据来源单据获取单据信息
        RecOrderSaveParam param = null;
        try {
            param = getLklRecOrderSaveParam(weChatPayRecOrderRpcParam, docIdMap, receiptAmtMap);
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        log.info("单据号:{},receiptAmtMap:{}", JSONUtil.toJsonStr(docIdMap), JSONUtil.toJsonStr(receiptAmtMap));
        Long docId = docIdMap.get("docId");
        Map<String, Set<Long>> paymentRuleIdsMap = new HashMap<>();
       /* resId = recOrderService.save(param).getData();
        entityManager.flush();
        entityManager.clear();
        String recOrderNo = recOrderService.queryById(resId).getRecOrderNo();*/
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        RecOrderSaveParam finalParam = param;
        resId = transactionTemplate.execute(trans -> {
            Long id = null;
            try {
                id = recOrderService.save(finalParam).getData();
                entityManager.flush();
                entityManager.clear();
                String recOrderNo = recOrderService.queryById(id).getRecOrderNo();
                log.info("已经完成收款单创建:{},收款单号:{}", JSONUtil.toJsonStr(finalParam), recOrderNo);

                //生成付款单
                RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(id);
                List<RecOrderDtlDTO> recOrderDtlDTOS = recOrderDtlRepoProc.queryByMasId(id);
                PayOrderSaveParam payOrderSaveParam = getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                payOrderService.save(payOrderSaveParam);
                log.info("已经完成付款单创建");

                //开始为对应储值账户生成账户流水
                Set<Long> paymentRuleIds = generateStoreAccountFlow(finalParam, recOrderNo, id);
                paymentRuleIdsMap.put("paymentRuleIds", paymentRuleIds);
            } catch (Exception e) {
                log.error("保存收款单生成流水发生错误:{}", e.getMessage(), e);
                sendWechatBoot(sourceNo, e.getMessage());
                trans.setRollbackOnly();
            }
            return id;
        });

        //调用支付
        log.info("支付规则id字典:{}", JSONUtil.toJsonStr(paymentRuleIdsMap));
        try {
            Set<Long> paymentRuleIds = paymentRuleIdsMap.get("paymentRuleIds");
            BigDecimal receiptAmt = receiptAmtMap.getOrDefault(docId, BigDecimal.ZERO);
            if (sourceNo.startsWith("PO")) {
                PoPayRpcDTO poPayRpcDTO = new PoPayRpcDTO();
                poPayRpcDTO.setId(docId);
                poPayRpcDTO.setDocNo(sourceNo);
                poPayRpcDTO.setReceiptAmt(receiptAmt);
                poPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                log.info("调用采购订单支付,参数:{}", JSONUtil.toJsonStr(poPayRpcDTO));
                poPayProvider.pay(poPayRpcDTO);
            } else { //调拨订单支付
                try {
                    TroPayRpcDTO troPayRpcDTO = new TroPayRpcDTO();
                    troPayRpcDTO.setId(docId);
                    troPayRpcDTO.setDocNo(sourceNo);
                    troPayRpcDTO.setReceiptAmt(receiptAmt);
                    troPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                    log.info("调用调拨订单支付,参数:{}", JSONUtil.toJsonStr(troPayRpcDTO));
                    troPayProvider.pay(troPayRpcDTO);
                } catch (Exception e) {
                    log.warn("调用调拨订单支付异常:{}", e.getMessage(), e);
                    throw new com.elitescloud.boot.exception.BusinessException("调用调拨订单支付异常:" + e.getMessage(), e);
                }
            }
        } catch (Exception e) {
            sendWechatBoot(sourceNo, e.getMessage());
        }
        log.info("调用调拨订单支付完成");

        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(resId);
        log.info("拉卡拉生成收款单审批通过，开始自动核销:{}", JSONUtil.toJsonStr(recOrderDTO));
        CompletableFuture.runAsync(
                () -> {
                    finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
                }
                , taskExecutor);
        log.info("拉卡拉返回");
        return resId;
    }


    private PayOrderSaveParam getPayOrderSaveParam(RecOrderDTO recOrderDTO, List<RecOrderDtlDTO> recOrderDtlDTOS) {
        log.info("生成付款单入参:recOrderDTO:{},recOrderDtlDTOS:{}", JSONUtil.toJsonStr(recOrderDTO),
                JSONUtil.toJsonStr(recOrderDtlDTOS));
        //获取客户信息
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(recOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("客户信息:{}", JSONUtil.toJsonStr(custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("客户关联公司编码:{}", corBusinCode);
        if (StrUtil.isBlank(corBusinCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户对应的公司编码不存在");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes =
                rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单客户对应的公司信息不存在");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("客户关联公司信息:{}", JSONUtil.toJsonStr(orgOuRpcSimpleDTO));

        //获取公司关联的供应商信息
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(recOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("收款单公司关联的供应商不存在");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);

        PayOrderSaveParam param = new PayOrderSaveParam();
        //内外部
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());
        //币种
        param.setCurrCode(recOrderDTO.getCurrCode());
        param.setCurrName(recOrderDTO.getCurrName());
        //公司
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        //付款公司
        param.setPayOuId(orgOuRpcSimpleDTO.getId());
        param.setPayOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setPayOuName(orgOuRpcSimpleDTO.getOuName());
        param.setPayOuSameFlag(true);
        //供应商
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        //来源系统单号
        param.setSourceNo(recOrderDTO.getRecOrderNo());
        //付款单类型
        param.setPayTypeCode("AP");
        param.setPayTypeName("标准付款");
        param.setPayTypeId(getApTypeIdByCode("AP"));
        //来源单据
        param.setCreateMode("REC");
        //总金额
        param.setTotalAmt(recOrderDTO.getTotalAmt());
        //实际支付金额
        param.setRealPayAmt(recOrderDTO.getRealRecAmt());
        //业务日期
        param.setBuDate(recOrderDTO.getReDate());
        //是否期初
        param.setInitFlag(recOrderDTO.getInitFlag());
        //总金额（本位币）
        param.setTotalCurAmt(recOrderDTO.getTotalCurAmt());
        //实际支付金额（本位币）
        param.setRealPayCurAmt(recOrderDTO.getRealRecCurAmt());
        //预计付款日期
        param.setApDate(recOrderDTO.getReDate());
        //是否预付
        param.setApFlag(recOrderDTO.getReFlag());
        //汇率
        param.setExchangeRate(recOrderDTO.getExchangeRate());
        //状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(recOrderDTO.getRedState());
        //红冲对应原单号
        String redSourceNo = recOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank(redSourceNo)) {
            List<PayOrderDO> payOrderDOS = payOrderRepoProc.queryBySourceNo(redSourceNo);
            if (CollUtil.isNotEmpty(payOrderDOS)) {
                PayOrderDO payOrderDO = payOrderDOS.get(0);
                param.setRedSourceNo(payOrderDO.getPayOrderNo());
                param.setRedSourceId(payOrderDO.getId());
                param.setRedState(true);
            }
        }
        Map<String, List<RecOrderDtlDTO>> groupedData =
                recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getRecAccount() + e.getEs16()));
        log.info("分组后 groupedData:{}", JSONUtil.toJsonStr(groupedData));
        //拟定状态
        param.setProposedStatus("DRAFT");
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = groupedData.entrySet().stream().map(
                entry -> {
                    BigDecimal realRecAmtTotal = BigDecimal.ZERO;
                    BigDecimal realRecCurAmtTotal = BigDecimal.ZERO;
                    for (RecOrderDtlDTO recOrderDtlDTO : entry.getValue()) {
                        realRecAmtTotal = realRecAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecAmt()));
                        realRecCurAmtTotal =
                                realRecCurAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecCurAmt()));
                    }
                    RecOrderDtlDTO payorderDtlDto = entry.getValue().get(0);
                    BigDecimal totalAmt =
                            entry.getValue().stream().filter(e -> e.getTotalAmt() != null).map(RecOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalCurAmt =
                            entry.getValue().stream().filter(e -> e.getTotalCurAmt() != null).map(RecOrderDtlDTO::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    PayOrderDtlSaveParam payOrderDtlSaveParam = new PayOrderDtlSaveParam();
                    //来源行号
                    payOrderDtlSaveParam.setSourceLine(payorderDtlDto.getSourceLine());
                    payOrderDtlSaveParam.setSourceLineId(payorderDtlDto.getSourceLineId());
                    //付款方式
                    payOrderDtlSaveParam.setPayType(payorderDtlDto.getRecType());
                    //我方银行账户
                    payOrderDtlSaveParam.setPayBank(payorderDtlDto.getEs17());
                    //我方银行账号
                    payOrderDtlSaveParam.setPayAccount(payorderDtlDto.getEs16());
                    //总金额
                    payOrderDtlSaveParam.setTotalAmt(totalAmt);
                    //总金额（本位币）
                    payOrderDtlSaveParam.setTotalCurAmt(totalCurAmt);
                    //收款方银行账户
                    payOrderDtlSaveParam.setRecBank(payorderDtlDto.getRecBank());
                    //收款方银行账号
                    payOrderDtlSaveParam.setRecAccount(payorderDtlDto.getRecAccount());
                    //实际支付金额
                    payOrderDtlSaveParam.setRealPayAmt(realRecAmtTotal);
                    //实际支付金额（本位币）
                    payOrderDtlSaveParam.setRealPayCurAmt(realRecCurAmtTotal);
                    //已核销金额
                    payOrderDtlSaveParam.setVerAmt(BigDecimal.ZERO);
                    //未核销金额
                    payOrderDtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
                    //核销中金额
                    payOrderDtlSaveParam.setUnVerAmt(param.getTotalAmt());
                    return payOrderDtlSaveParam;
                }
        ).collect(Collectors.toList());
        param.setPayOrderDtlSaveParams(payOrderDtlSaveParams);
        log.info("生成付款单参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }
    
    private Set<Long> generateStoreAccountFlow(RecOrderSaveParam param, String recOrderNo, Long resId) {
        log.info("开始查询账户信息,收款公司编码:{},客户编码:{}", param.getRecOuCode(), param.getCustCode());
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOS = queryAccountInfo(param.getRecOuCode(),
                param.getCustCode(), param.getSourceNo());
        if (CollUtil.isEmpty(paymentRuleConfigDtlDTOS)) {
            throw new com.elitescloud.boot.exception.BusinessException("客户账号有误！");
        }
        log.info("账户信息:{}", JSONUtil.toJsonStr(paymentRuleConfigDtlDTOS));
        Set<Long> paymentRuleIds =
                paymentRuleConfigDtlDTOS.stream().map(BaseModelDTO::getId).collect(Collectors.toSet());
        //获取储值账户
        PaymentRuleConfigDtlDTO storePaymentRuleConfig =
                paymentRuleConfigDtlDTOS.stream().filter(e -> "STORE".equals(e.getAccountType())).findFirst().orElseThrow(new com.elitescloud.boot.exception.BusinessException("没有找关联的储值账户，无法产生账户流水"));
        log.info("储值账户信息:{}", JSONUtil.toJsonStr(storePaymentRuleConfig));
        List<GenerateAccountFlowRpcParam> params = new ArrayList<>();
        params.add(createGenerateAccountFlowRpcParam("SKD", "SKD", "COMPLETE",
                recOrderNo,
                resId, "STORE", storePaymentRuleConfig.getAccountTypeName(),
                storePaymentRuleConfig.getAccountCode(), storePaymentRuleConfig.getAccountName(),
                param.getTotalAmt()));
        log.info("调用财务域生成账户流水,参数:{}", JSONUtil.toJsonStr(params));
        // 来源单据是调拨订单或采购订单，根据采购订单和调拨订单查订货单号
        if(UdcEnum.FIN_REC_DOC_CLS_PO.getValueCode().equals(param.getCreateMode())){
            List<PurPoDTO> purPoDTO = purPoProvider.findCodeBatch(Collections.singletonList((param.getSourceNo())));
            log.info("调用财务域生成账户流水，查询采购订单信息:{}", JSONUtil.toJsonStr(purPoDTO));
            if(CollectionUtils.isNotEmpty(purPoDTO)){
                params.forEach(finParam -> {
                    finParam.setRootDocId(purPoDTO.get(0).getRelateDocId());
                    finParam.setRootDocNo(purPoDTO.get(0).getRelateDocNo());
                    finParam.setRootDocType(purPoDTO.get(0).getRelateDocCls());
                });
            }
        }
        if(UdcEnum.FIN_REC_DOC_CLS_TRO.getValueCode().equals(param.getCreateMode())){
            ApiResult<InvTroRpcDTO> troRpcNo = invTroProvider.findByDocNo(param.getSourceNo());
            log.info("调用财务域生成账户流水，查询调拨订单信息:{}", JSONUtil.toJsonStr(troRpcNo));
            if(troRpcNo.isSuccess() && troRpcNo.getData() != null){
                InvTroRpcDTO troDTO = troRpcNo.getData();
                params.forEach(finParam -> {
                    finParam.setRootDocId(troDTO.getRelateDocId());
                    finParam.setRootDocNo(troDTO.getRelateDocNo());
                    finParam.setRootDocType(troDTO.getRelateDocCls());
                });
            }
        }
        log.info("调用财务域生成账户流水,处理跟单号后参数:{}", JSONUtil.toJsonStr(params));
        List<GenerateAccountFlowRpcDTO> generateAccountFlowRpcDTOS =
                generateAccountFlow(params, Boolean.TRUE);
        log.info("调用财务域生成账户流水,结果:{}", JSONUtil.toJsonStr(generateAccountFlowRpcDTOS));
        return paymentRuleIds;
    }

    private List<GenerateAccountFlowRpcDTO> generateAccountFlow(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList, Boolean needMerge) {
        log.info("【调用财务域】生成流水-参数(合并前)：{}", JSONUtil.toJsonStr(generateAccountFlowRpcParamList));
        ApiResult<List<GenerateAccountFlowRpcDTO>> refundResult;
        GenerateAccountFlowRpcService rpcService = SpringUtil.getBean(GenerateAccountFlowRpcService.class);
        if (needMerge) {
            List<GenerateAccountFlowRpcParam> params = mergeParams(generateAccountFlowRpcParamList);
            log.info("【调用财务域】生成流水-参数(合并后)：{}", JSONUtil.toJsonStr(params));
            refundResult = rpcService.generateAccountFlow(params);
        } else {
            refundResult = rpcService.generateAccountFlow(generateAccountFlowRpcParamList);
        }
        log.info("【调用财务域】生成流水-结果：{}", JSONUtil.toJsonStr(refundResult));
        if (!refundResult.isSuccess()) {
            throw new com.elitescloud.boot.exception.BusinessException("财务域生成流水报错：" + refundResult.getMsg());
        }
        return refundResult.getData();
    }

    /**
     * 合并 财务域生成流程号 参数
     */
    private static List<GenerateAccountFlowRpcParam> mergeParams(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList) {
        Map<String, GenerateAccountFlowRpcParam> generateAccountFlowRpcParamMap = new HashMap<>();
        for (GenerateAccountFlowRpcParam generateAccountFlowRpcParam : generateAccountFlowRpcParamList) {
            String key =
                    generateAccountFlowRpcParam.getAccountType() + "-" + generateAccountFlowRpcParam.getAccountCode();
            if (!generateAccountFlowRpcParamMap.containsKey(key)) {
                generateAccountFlowRpcParamMap.put(key, generateAccountFlowRpcParam);
            } else {
                GenerateAccountFlowRpcParam param = generateAccountFlowRpcParamMap.get(key);
                param.setDocAmount(param.getDocAmount().add(generateAccountFlowRpcParam.getDocAmount()));//累加金额
            }
        }
        return generateAccountFlowRpcParamMap.values().stream().collect(Collectors.toList());
    }

    private GenerateAccountFlowRpcParam createGenerateAccountFlowRpcParam(String docNo, String docType,
                                                                          String docStatus, String soDocNo,
                                                                          Long sourceId, String accountType,
                                                                          String accountTypeName,
                                                                          String payAccNo, String payAccName,
                                                                          BigDecimal docAmount) {
        GenerateAccountFlowRpcParam param = new GenerateAccountFlowRpcParam();
        //公共
        param.setDoc(docNo);
        param.setDocType(docType);
        param.setDocStatus(docStatus);
        //信息
        param.setDocAmount(docAmount);
        param.setSourceId(sourceId);
        param.setSourceNo(soDocNo);
        param.setAccountType(accountType);
        param.setAccountTypeName(accountTypeName);
        param.setAccountCode(payAccNo);
        param.setAccountName(payAccName);
        log.info("流水构造参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }

    public List<PaymentRuleConfigDtlDTO> queryAccountInfo(String ouCode, String custCode, String docNo) {
        /**
         * 数据验证
         */
        if (StrUtil.isBlank(ouCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("公司编码不能为空");
        }
        if (StrUtil.isBlank(custCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("客户编码不能为空");
        }

        /**
         * 参数
         */

        PaymentRuleConfigParam param = new PaymentRuleConfigParam();
        //公共
        if (docNo.startsWith("PO")) {
            param.setDoc("PO");//单据
            param.setDocType("PO");//单据类型
            param.setDocStatus("APPED");//收款信息状态
        } else {
            param.setDoc("STKTRO");//单据
            param.setDocType("TRO");//单据类型
            param.setDocStatus("APPED");//收款信息状态
        }
        //业务
        param.setSourceId(RandomUtil.randomLong());//来源单据id
//        param.setSourceNo(receiptCommand.getId().toString());//来源单号
        param.setSourceNo(IdUtil.randomUUID());//来源单号
        param.setOuCode(ouCode);//公司编码
        param.setObjectCode(custCode);//客户编码
        param.setDocAmount(BigDecimal.ONE);//来源单据金额（收款金额）
        param.setRebateAmount(null);
        param.setPaymentRuleConfigDtlIds(null);


        /**
         * 调用财务域（查询账号信息）
         */
        return paymentRuleConfigService.queryAccountAmount(param);
    }


    private RecOrderSaveParam getRecOrderSaveParam(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam, Map<String,
            Long> docMap, Map<Long, BigDecimal> receiptAmtMap) {
        RecOrderSaveParam param = new RecOrderSaveParam();
        String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();

        param.setSourceNo(sourceNo);
        //收款单类型
        param.setRecTypeCode("SKD01_SYS");
        param.setRecTypeName("标准收款单");
        param.setRecTypeId(getRecTypeIdByCode("SKD01_SYS"));
        //收款日期
        param.setReDate(weChatPayRecOrderRpcParam.getPayDateTime());
        //币种
        param.setCurrCode(weChatPayRecOrderRpcParam.getCurrCode());
        param.setCurrName(weChatPayRecOrderRpcParam.getCurrName());
        //来源单据
        if (sourceNo.startsWith("PO")) {
            param.setCreateMode("PO");
            List<PurPoDTO> codeBatch = purPoProvider.findCodeBatch(Arrays.asList(sourceNo));
            if (CollUtil.isEmpty(codeBatch)) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息不存在");
            }
            PurPoDTO purPoDTO = codeBatch.get(0);
            if (purPoDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息不存在");
            }
            docMap.put("docId", purPoDTO.getId());
            PurPoDTO data = purPoProvider.findPurPoOne(purPoDTO.getId()).getData();
            if (data != null) {
                receiptAmtMap.put(purPoDTO.getId(),
                        data.getPurPoDDTOList().stream().map(PurPoDDTO::getLastPathSaleAmt).filter(Objects::nonNull
                        ).reduce(BigDecimal.ZERO,
                                BigDecimal::add));
            }

            log.info("采购单详情:{},采购订单,docId:{},receiptAmtMap:{}", JSONUtil.toJsonStr(purPoDTO), purPoDTO.getId(),
                    JSONUtil.toJsonStr(receiptAmtMap));
            InvWhRpcSimpleDTO whRpcSimpleDTO = invWhProvider.querySimple(List.of(purPoDTO.getWhId())).getData().get(0);
            ApiResult<OrgStoreBaseRpcDTO> orgStoreByWhCode =
                    orgStoreRpcService.getOrgStoreByWhCode(whRpcSimpleDTO.getWhCode());
            if (orgStoreByWhCode.isSuccess() && orgStoreByWhCode.getData() == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息关联门店不存在");
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息关联门店不存在");
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());


            SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
            rpcParam.setCompanyIdStart(purPoDTO.getOuId());
            rpcParam.setCompanyIdEnd(purPoDTO.getAcceptOuId());
            SupportTransactionPathRpcDTO pathCodeResult =
                    supportTransactionPathRpcService.queryByParam(rpcParam).getData();
            if (pathCodeResult == null) {
                log.info("采购订单:{},未获取到结算路径信息:{}", purPoDTO.getDocNo(), JSONUtil.toJsonStr(rpcParam));
                throw new com.elitescloud.boot.exception.BusinessException("采购订单,未获取到结算路径信息");
            }
            log.info("获取到结算路径信息:{}", JSONUtil.toJsonStr(pathCodeResult));
            List<SupportTransactionPathDRpcDTO> detailList = pathCodeResult.getDetailList();
            int size = detailList.size();
            SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
            //销售公司
            param.setOuCode(dto.getCompanyCodeStart());
            param.setOuId(dto.getCompanyIdStart());
            param.setOuName(dto.getCompanyNameStart());
            //客户
            param.setCustCode(dto.getCustCodeEnd());
            param.setCustId(dto.getCustIdEnd());
            param.setCustName(dto.getCustNameEnd());

            //收款公司
            param.setRecOuId(dto.getCompanyIdStart());
            param.setRecOuCode(dto.getCompanyCodeStart());
            param.setRecOuName(dto.getCompanyNameStart());
        } else {
            CompanyAndCustRpcDTO companyAndCustRpcDTO =
                    invCompanyAndCustProvider.getFromCompanyAndToCustomer(sourceNo);
            //销售公司
            param.setOuCode(companyAndCustRpcDTO.getOuCode());
            param.setOuId(companyAndCustRpcDTO.getOuId());
            param.setOuName(companyAndCustRpcDTO.getOuName());
            //客户
            param.setCustCode(companyAndCustRpcDTO.getCustCode());
            param.setCustId(companyAndCustRpcDTO.getCustId());
            param.setCustName(companyAndCustRpcDTO.getCustName());

            param.setCreateMode("TRO");
            //门店名称
            ApiResult<InvTroRpcDTO> byDocNo = invTroProvider.findByDocNo(sourceNo);
            if (!byDocNo.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单信息不存在");
            }
            InvTroRpcDTO invTroRpcDTO = byDocNo.getData();
            log.info("调拨单信息:{}", JSONUtil.toJsonStr(invTroRpcDTO));
            if (invTroRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单信息不存在");
            }
            docMap.put("docId", invTroRpcDTO.getId());
            receiptAmtMap.put(invTroRpcDTO.getId(),
                    invTroRpcDTO.getInvTrnDRpcDTOS().stream().map(InvTroDRpcDTO::getLastPathSaleAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            log.info("调拨单,docId:{},receiptAmtMap:{}", invTroRpcDTO.getId(), JSONUtil.toJsonStr(receiptAmtMap));

            if (StrUtil.isBlank(invTroRpcDTO.getToWhCode())) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单收货仓库不存在");
            }
            ApiResult<OrgStoreBaseRpcDTO> orgStoreByWhCode =
                    orgStoreRpcService.getOrgStoreByWhCode(invTroRpcDTO.getToWhCode());
            if (!orgStoreByWhCode.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("门店信息不存在,仓库编码为:" + invTroRpcDTO.getToWhCode());
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("门店信息不存在,仓库编码为:" + invTroRpcDTO.getToWhCode());
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            //收款公司
            param.setRecOuId(companyAndCustRpcDTO.getOuId());
            param.setRecOuCode(companyAndCustRpcDTO.getOuCode());
            param.setRecOuName(companyAndCustRpcDTO.getOuName());
        }

        //汇率
        param.setExchangeRate(BigDecimal.ONE);
        //总金额
        param.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //总金额（本位币)
        param.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //实际收款金额
        param.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //实际收款金额（本位币）
        param.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //是否预收
        param.setReFlag(false);
        //是否期初
        param.setInitFlag(false);
        //单据状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(false);
        //拟定状态
        param.setProposedStatus("DRAFT");

        //构建明细信息
        RecOrderDtlSaveParam dtlSaveParam = new RecOrderDtlSaveParam();
        //来源单号
        dtlSaveParam.setSourceNo(sourceNo);
        dtlSaveParam.setRecType("WQF");
        dtlSaveParam.setRecTypeName("微企付");

        String storeCode = param.getStoreCode();
        List<OrgBankRpcDTO> bankByStoreCode = rmiOrgStoreRpcServiceService.findBankByStoreCode(storeCode);
        if (!bankByStoreCode.isEmpty()) {
            OrgBankRpcDTO orgBankRpcDTO = bankByStoreCode.get(0);
            //todo 获取门店的付款账号
            dtlSaveParam.setEs16(orgBankRpcDTO.getCardNo());
            //todo 获取门店的付款账户
            dtlSaveParam.setEs17(orgBankRpcDTO.getOpenBank());
        }


        Long ouId = param.getRecOuId();
        List<OrgOuBankRpcDTO> ouBankData = rmiOrgOuRpcServiceService.findOuBank(ouId);
        OrgOuBankRpcDTO bankRpcDTO = ouBankData.stream().filter(e -> "WQF".equals(e.getPayCollectMethod()) &&
                "IN".equals(e.getAccType())).findFirst().orElseThrow(new com.elitescloud.boot.exception.BusinessException("收款公司银行信息无微企付收款信息"));
        //收款账号 获取收款公司维护的银行信息，收款方式=微企付/营账通且账户类型=收款账户的户名
        dtlSaveParam.setRecAccount(bankRpcDTO.getBankAcc());
        //收款账户 获取收款公司维护的银行信息，收款方式=微企付/营账通且账户类型=收款账户的账号
        dtlSaveParam.setRecBank(bankRpcDTO.getHolderName());
        //收款流水 微企付订单号
        dtlSaveParam.setRecFlow(weChatPayRecOrderRpcParam.getFlowNo());
        dtlSaveParam.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setVerAmt(BigDecimal.ZERO);
        dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
        dtlSaveParam.setUnVerAmt(param.getTotalAmt());
        param.setOrderDtlSaveParamList(Arrays.asList(dtlSaveParam));
        log.info("生成的收款单详情:{}", JSONUtil.toJsonStr(param));
        return param;
    }

    private RecOrderSaveParam getLklRecOrderSaveParam(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam, Map<String,
            Long> docMap, Map<Long, BigDecimal> receiptAmtMap) {
        RecOrderSaveParam param = new RecOrderSaveParam();
        String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();

        param.setSourceNo(sourceNo);
        //收款单类型
        param.setRecTypeCode("SKD01_SYS");
        param.setRecTypeName("标准收款单");
        param.setRecTypeId(getRecTypeIdByCode("SKD01_SYS"));
        //收款日期
        param.setReDate(weChatPayRecOrderRpcParam.getPayDateTime());
        //币种
        param.setCurrCode(weChatPayRecOrderRpcParam.getCurrCode());
        param.setCurrName(weChatPayRecOrderRpcParam.getCurrName());
        //来源单据
        if (sourceNo.startsWith("PO")) {
            param.setCreateMode("PO");
            List<PurPoDTO> codeBatch = purPoProvider.findCodeBatch(Arrays.asList(sourceNo));
            if (CollUtil.isEmpty(codeBatch)) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息不存在");
            }
            PurPoDTO purPoDTO = codeBatch.get(0);
            if (purPoDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息不存在");
            }
            docMap.put("docId", purPoDTO.getId());
            PurPoDTO data = purPoProvider.findPurPoOne(purPoDTO.getId()).getData();
            if (data != null) {
                receiptAmtMap.put(purPoDTO.getId(),
                        data.getPurPoDDTOList().stream().map(PurPoDDTO::getLastPathSaleAmt).filter(Objects::nonNull
                        ).reduce(BigDecimal.ZERO,
                                BigDecimal::add));
            }

            log.info("采购单详情:{},采购订单,docId:{},receiptAmtMap:{}", JSONUtil.toJsonStr(purPoDTO), purPoDTO.getId(),
                    JSONUtil.toJsonStr(receiptAmtMap));
            InvWhRpcSimpleDTO whRpcSimpleDTO = invWhProvider.querySimple(List.of(purPoDTO.getWhId())).getData().get(0);
            ApiResult<OrgStoreBaseRpcDTO> orgStoreByWhCode =
                    orgStoreRpcService.getOrgStoreByWhCode(whRpcSimpleDTO.getWhCode());
            if (orgStoreByWhCode.isSuccess() && orgStoreByWhCode.getData() == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息关联门店不存在");
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("采购订单信息关联门店不存在");
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());


            SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
            rpcParam.setCompanyIdStart(purPoDTO.getOuId());
            rpcParam.setCompanyIdEnd(purPoDTO.getAcceptOuId());
            SupportTransactionPathRpcDTO pathCodeResult =
                    supportTransactionPathRpcService.queryByParam(rpcParam).getData();
            if (pathCodeResult == null) {
                log.info("采购订单:{},未获取到结算路径信息:{}", purPoDTO.getDocNo(), JSONUtil.toJsonStr(rpcParam));
                throw new com.elitescloud.boot.exception.BusinessException("采购订单,未获取到结算路径信息");
            }
            log.info("获取到结算路径信息:{}", JSONUtil.toJsonStr(pathCodeResult));
            List<SupportTransactionPathDRpcDTO> detailList = pathCodeResult.getDetailList();
            int size = detailList.size();
            SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
            //销售公司
            param.setOuCode(dto.getCompanyCodeStart());
            param.setOuId(dto.getCompanyIdStart());
            param.setOuName(dto.getCompanyNameStart());
            //客户
            param.setCustCode(dto.getCustCodeEnd());
            param.setCustId(dto.getCustIdEnd());
            param.setCustName(dto.getCustNameEnd());

            //收款公司
            param.setRecOuId(dto.getCompanyIdStart());
            param.setRecOuCode(dto.getCompanyCodeStart());
            param.setRecOuName(dto.getCompanyNameStart());
        } else {
            CompanyAndCustRpcDTO companyAndCustRpcDTO =
                    invCompanyAndCustProvider.getFromCompanyAndToCustomer(sourceNo);
            //销售公司
            param.setOuCode(companyAndCustRpcDTO.getOuCode());
            param.setOuId(companyAndCustRpcDTO.getOuId());
            param.setOuName(companyAndCustRpcDTO.getOuName());
            //客户
            param.setCustCode(companyAndCustRpcDTO.getCustCode());
            param.setCustId(companyAndCustRpcDTO.getCustId());
            param.setCustName(companyAndCustRpcDTO.getCustName());

            param.setCreateMode("TRO");
            //门店名称
            ApiResult<InvTroRpcDTO> byDocNo = invTroProvider.findByDocNo(sourceNo);
            if (!byDocNo.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单信息不存在");
            }
            InvTroRpcDTO invTroRpcDTO = byDocNo.getData();
            log.info("调拨单信息:{}", JSONUtil.toJsonStr(invTroRpcDTO));
            if (invTroRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单信息不存在");
            }
            docMap.put("docId", invTroRpcDTO.getId());
            receiptAmtMap.put(invTroRpcDTO.getId(),
                    invTroRpcDTO.getInvTrnDRpcDTOS().stream().map(InvTroDRpcDTO::getLastPathSaleAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            log.info("调拨单,docId:{},receiptAmtMap:{}", invTroRpcDTO.getId(), JSONUtil.toJsonStr(receiptAmtMap));

            if (StrUtil.isBlank(invTroRpcDTO.getToWhCode())) {
                throw new com.elitescloud.boot.exception.BusinessException("调拨单收货仓库不存在");
            }
            ApiResult<OrgStoreBaseRpcDTO> orgStoreByWhCode =
                    orgStoreRpcService.getOrgStoreByWhCode(invTroRpcDTO.getToWhCode());
            if (!orgStoreByWhCode.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("门店信息不存在,仓库编码为:" + invTroRpcDTO.getToWhCode());
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("门店信息不存在,仓库编码为:" + invTroRpcDTO.getToWhCode());
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            //收款公司
            param.setRecOuId(companyAndCustRpcDTO.getOuId());
            param.setRecOuCode(companyAndCustRpcDTO.getOuCode());
            param.setRecOuName(companyAndCustRpcDTO.getOuName());
        }

        //汇率
        param.setExchangeRate(BigDecimal.ONE);
        //总金额
        param.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //总金额（本位币)
        param.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //实际收款金额
        param.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //实际收款金额（本位币）
        param.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        //是否预收
        param.setReFlag(false);
        //是否期初
        param.setInitFlag(false);
        //单据状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(false);
        //拟定状态
        param.setProposedStatus("DRAFT");

        //构建明细信息
        RecOrderDtlSaveParam dtlSaveParam = new RecOrderDtlSaveParam();
        //来源单号
        dtlSaveParam.setSourceNo(sourceNo);
        dtlSaveParam.setRecType("LKL");
        dtlSaveParam.setRecTypeName("拉卡拉");
        dtlSaveParam.setRecKind("LKL_PRE");

        String storeCode = param.getStoreCode();
        List<OrgBankRpcDTO> bankByStoreCode = rmiOrgStoreRpcServiceService.findBankByStoreCode(storeCode);
        if (!bankByStoreCode.isEmpty()) {
            bankByStoreCode.stream().filter(e -> e.getOpenBank().equals("拉卡拉")).findFirst().ifPresent(s -> {
                dtlSaveParam.setEs16(s.getCardNo());
                dtlSaveParam.setEs17(s.getOpenBank());
            });
        }


        Long ouId = param.getRecOuId();
        List<OrgOuBankRpcDTO> ouBankData = rmiOrgOuRpcServiceService.findOuBank(ouId);
        OrgOuBankRpcDTO bankRpcDTO = ouBankData.stream().filter(e -> "拉卡拉".equals(e.getBankName()) &&
                "IN".equals(e.getAccType())).findFirst().orElseThrow(new com.elitescloud.boot.exception.BusinessException("收款公司银行信息无拉卡拉收款信息"));
        //收款账号 获取收款公司维护的银行信息，收款方式=微企付/营账通且账户类型=收款账户的户名
        dtlSaveParam.setRecAccount(bankRpcDTO.getBankAcc());
        //收款账户 获取收款公司维护的银行信息，收款方式=微企付/营账通且账户类型=收款账户的账号
        dtlSaveParam.setRecBank(bankRpcDTO.getBankName());
        //收款流水 微企付订单号
        dtlSaveParam.setRecFlow(weChatPayRecOrderRpcParam.getFlowNo());
        dtlSaveParam.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setVerAmt(BigDecimal.ZERO);
        dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
        dtlSaveParam.setUnVerAmt(param.getTotalAmt());
        param.setOrderDtlSaveParamList(Arrays.asList(dtlSaveParam));
        log.info("生成的收款单详情:{}", JSONUtil.toJsonStr(param));
        return param;
    }

    /**
     * 对来源单据号做重复性校验
     *
     * @param sourceNo
     */
    private void checkIfExist(String sourceNo) {
        List<RecOrderDO> bySourceNo = recOrderRepoProc.findBySourceNo(sourceNo);
        if (CollUtil.isNotEmpty(bySourceNo)) {
            throw new com.elitescloud.boot.exception.BusinessException("该来源单号已存在关联的收款单,来源单号:" + sourceNo);
        }

    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<PayTypeVO> payTypeVOList = payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    private Long getRecTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<RecTypeDTO> apTypeDTOS = recTypeDomainService.findAll();
        Optional<RecTypeDTO> first = apTypeDTOS.stream().filter(e -> e.getRecTypeCode().equals(code)).findFirst();
        return first.map(RecTypeDTO::getId).orElse(null);
    }

    private void sendWechatBoot(String docNo, String msg) {
        try {

            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WECHAT_PAY");
            //处理内容文本占位传参 start
            Map<String, String> contentTemplateParams = new HashMap<>();
            contentTemplateParams.put("DOC_NO", docNo);
            contentTemplateParams.put("MSG", msg);
            dto.setContentReplaceMap(contentTemplateParams);
            sysMsgTemplateSendRpcService.msgTemplateSend(dto);
            log.debug("企微消息发送成功：" + LocalDateTime.now());
        } catch (Exception e) {
            log.error("发送告警信息失败，" + ExceptionUtils.getStackTrace(e));
        }
    }
}
