package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_set_of_book")
@org.hibernate.annotations.Table(appliesTo = "fin_set_of_book", comment = "账套")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinSetOfBookDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "sob_code", columnDefinition = "varchar(20) comment '账套编码'")
    private String sobCode;

    @Column(name = "sob_name", columnDefinition = "varchar(32) comment '账套名称'")
    private String sobName;

    @Column(name = "account_period_code", columnDefinition = "varchar(20) comment '会计期间编码'")
    private String accountPeriodCode;

    @Column(name = "account_period_name", columnDefinition = "varchar(32) comment '会计期间名称'")
    private String accountPeriodName;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '本位币'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(20) comment '本位币名称'")
    private String currName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;

    @Column(name = "sync_status", columnDefinition = "varchar(32) comment '同步状态'")
    private String syncStatus;

    @Column(name = "sync_error", columnDefinition = "varchar(32) comment '异常原因'")
    private String syncError;

}
