package com.elitesland.fin.domain.entity.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "aging_range_ou")
@org.hibernate.annotations.Table(appliesTo = "aging_range_ou", comment = "账龄区间设置的分配公司")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class AgingRangeOuDO extends BaseModel implements Serializable {

    @Comment("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20)")
    private Long masId;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_type", columnDefinition = "varchar(32) comment '公司类型'")
    private String ouType;

}
