package com.elitesland.fin.infr.repo.payorder;

import com.elitesland.fin.domain.entity.payorder.QPayOrderSyncRecordDO;
import com.elitesland.fin.domain.param.payorder.SyncRecordParam;
import com.elitesland.fin.infr.dto.payorder.SyncRecordDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:40
 */
@Component
@RequiredArgsConstructor
public class SyncRecordRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderSyncRecordDO payOrderSyncRecordDO = QPayOrderSyncRecordDO.payOrderSyncRecordDO;

    public List<SyncRecordDTO> findSyncRecord(SyncRecordParam param) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        SyncRecordDTO.class,
                        payOrderSyncRecordDO.id,
                        payOrderSyncRecordDO.payOrderId,
                        payOrderSyncRecordDO.payOrderNo,
                        payOrderSyncRecordDO.businessNo,
                        payOrderSyncRecordDO.seqNo,
                        payOrderSyncRecordDO.syncStatus,
                        payOrderSyncRecordDO.syncError,
                        payOrderSyncRecordDO.outSysKey
                )).from(payOrderSyncRecordDO);
        var predicates = pageWhere(param);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    private List<Predicate> pageWhere(SyncRecordParam param) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotEmpty(param.getPayOrderNo())) {
            predicates.add(payOrderSyncRecordDO.payOrderNo.eq(param.getPayOrderNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getPayOrderNoList())) {
            predicates.add(payOrderSyncRecordDO.payOrderNo.in(param.getPayOrderNoList()));
        }
        if (param.getPayOrderId() != null) {
            predicates.add(payOrderSyncRecordDO.payOrderId.eq(param.getPayOrderId()));
        }
        if (CollectionUtils.isNotEmpty(param.getPayOrderIdList())) {
            predicates.add(payOrderSyncRecordDO.payOrderId.in(param.getPayOrderIdList()));
        }
        return predicates;
    }

}
