package com.elitesland.fin.domain.entity.arorder;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lucan.liu
 * @date 2023-09-04 19:14
 */
@Data
@Entity
@Table(name = "ar_order_ext_dtl")
@DynamicInsert
@DynamicUpdate
@Comment("应收单明细表扩展表")
public class ArOderExDtlDo extends BaseModel implements Serializable {

    private static final long serialVersionUID = 4530231083180083771L;

    @ApiModelProperty("应收单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '应收明细表关联id'")
    private Long relateId;

    @ApiModelProperty("应收主扩展表关联id")
    @Column(name = "mas_id", columnDefinition = "bigint(20)  comment '应收主扩展表关联id'")
    private Long masId;

    @ApiModelProperty("发货单号")
    @Column(name = "send_order", columnDefinition = "varchar(32)  comment '发货单号'")
    private String sendOrder;

    @ApiModelProperty("第三方应收单明细id")
    @Column(name = "third_order_dt_id", columnDefinition = "varchar(32)  comment '第三方应收单明细id'")
    private String thirdOrderDtId;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    @Column(name = "application_dt_id", columnDefinition = "varchar(32)  comment '发货单明细ID（开票申请单）'")
    private String applicationDtId;

    @ApiModelProperty("订单客户")
    @Column(name = "order_customer", columnDefinition = "varchar(32)  comment '订单客户'")
    private String orderCustomer;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "varchar(32)  comment '客户编码'")
    private String custCode;

    @ApiModelProperty("未税单价")
    @Column(name = "unitprice_before_tax", columnDefinition = "decimal(16,4)  comment '未税单价'")
    private BigDecimal unitpriceBeforeTax;

    @ApiModelProperty("税码")
    @Column(name = "tax_code", columnDefinition = "varchar(32)  comment '税码'")
    private String taxCode;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("发票类型")
    @Column(name = "invoice_type", columnDefinition = "varchar(32)  comment '发票类型'")
    private String invoiceType;

    @ApiModelProperty("收款协议")
    @Column(name = "recive_agreement", columnDefinition = "varchar(32)  comment '收款协议'")
    private String reciveAgreement;

    @ApiModelProperty("业务员编码")
    @Column(name = "business_code", columnDefinition = "varchar(32)  comment '业务员编码'")
    private String businessCode;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(32)  comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "exchange_rate", columnDefinition = "varchar(32)  comment '汇率'")
    private String exchangeRate;

    @ApiModelProperty("起算日期")
    @Column(name = "start_date", columnDefinition = "datetime(6)  comment '起算日期'")
    private LocalDateTime startDate;

    @ApiModelProperty("到期付款日")
    @Column(name = "payment_due_date", columnDefinition = "datetime(6)  comment '到期付款日'")
    private LocalDateTime paymentDueDate;

    @ApiModelProperty("已核销金额")
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

	@ApiModelProperty("nc订单号")
	@Column(name = "sal_so_doc_no", columnDefinition = "varchar(32)  comment 'nc订单号'")
	private String salSoDocNo;

    /**
     * 总金额.
     */
    @Transient
    private BigDecimal totalAmt;
    @Transient
    private Long extId;
    @Transient
    private Integer version;
    @Transient
    private Long arDId;
}