package com.elitesland.fin.domain.entity.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:13
 */
@Data
public class PayOrder {

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    private Long id;

    private String sourceNo;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String payOuCode;

    private Long payOuId;

    private String payOuName;

    private Boolean payOuSameFlag;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private Long payTypeId;

    private String payTypeCode;

    private String payTypeName;

    private String payOrderNo;

    private String currCode;

    private String currName;

    private String operator;

    private Long operUserId;

    private String buType;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private LocalDateTime buDate;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private Boolean initFlag;

    private BigDecimal realPayAmt;

    private BigDecimal realPayCurAmt;

    private LocalDateTime apDate;

    private Boolean apFlag;

    private String remark;

    private String auditRejection;

    private String createMode;

    private String localCurrCode;

    private String localCurrName;

    private String verState;

    private BigDecimal verAmt;

    private BigDecimal unVerAmt;

    private List<PayOrderDtl> dtlList;

    private String creator;

    private Integer auditDataVersion;

    private LocalDateTime createTime;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    private String proposedStatus;

    @ApiModelProperty("是否检验")
    private Boolean check = Boolean.TRUE;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty("制单状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("支付状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("失败原因")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

    @ApiModelProperty("交易流水号")
    private String transNo;

    @ApiModelProperty("受理流水号")
    private String rcvSeqNo;

    public void countMoney() {
        // 总金额
        BigDecimal totalAmountDtl = this.dtlList.stream()
                .map(PayOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 总金额 (本位币)
        BigDecimal totalCurAmountDtl = this.dtlList.stream()
                .map(PayOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 实际支付金额
        BigDecimal realPayAmtDtl = this.dtlList.stream()
                .map(PayOrderDtl::getRealPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 实际支付金额(本位币)
        BigDecimal realPayCurAmtDtl = this.dtlList.stream()
                .map(PayOrderDtl::getRealPayCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.totalAmt = totalAmountDtl;
        this.totalCurAmt = totalCurAmountDtl;
        this.realPayAmt = realPayAmtDtl;
        this.realPayCurAmt = realPayCurAmtDtl;
    }

    public void checkOrderState() {
        if (!check) {
            return;
        }
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能编辑付款单为草稿状态的单据!");
        }
    }

    public void defaultVer() {
        this.verAmt = BigDecimal.ZERO;
        this.verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
    }

    public void checkTotalMoney() {
        if (!check) {
            return;
        }
        if (realPayAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "实际支付金额不能为0!");
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "总金额不能为0!");
        }
        if (totalCurAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "总金额(本位币)不能为0!");
        }
        if (realPayCurAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "实际支付金额(本位币)不能为0!");
        }
        if (CollUtil.isEmpty(this.dtlList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行数据不能为空!");
        }
    }

    /**
     * @param flag 为true则为新增场景，为false则来源为应付
     */
    public void checkDtl(Boolean flag) {
        if (!check) {
            return;
        }
        dtlList.forEach(dtl -> {
            //非空校验
            dtl.checkNotNull(false, this.createMode);
            if (flag) {
                //金额校验
                dtl.checkMoney(this.exchangeRate);
            } else {
                dtl.countMoney(this.exchangeRate);
            }
        });
    }


    public void checkMoney() {
        if (!check) {
            return;
        }
        BigDecimal totalAmountDtl = this.dtlList.stream()
                .map(PayOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCarAmountDtl = this.dtlList.stream()
                .map(PayOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal realPayAmtDtl = this.dtlList.stream()
                .map(PayOrderDtl::getRealPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal realPayCurAmtDtl = this.dtlList.stream()
                .map(PayOrderDtl::getRealPayCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        //1.总金额：取值付款信息行-汇总行SUM（总金额）；
        if (this.totalAmt.compareTo(totalAmountDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额之和与总单总金额不等!");
        }
        //2.总金额本位币：取值付款信息行-汇总行SUM（总金额本位币）；
        if (this.totalCurAmt.compareTo(totalCarAmountDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额(本位币)之和与总单金额(本位币)不等!");
        }
        //3.实际支付金额：取值付款信息行-汇总行SUM（实际支付金额）；
        if (this.realPayAmt.compareTo(realPayAmtDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际支付金额之和与总单实际支付金额不等!");
        }
        //4.实际支付金额本位币：取值付款信息行-汇总行SUM（实际支付金额本位币）；
        if (this.realPayCurAmt.compareTo(realPayCurAmtDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际支付金额(本位币)之和与总单实际支付金额(本位币)不等!");
        }

    }

    //必填项非空校验
    public void checkNotNull(String createMode) {
        if (!check) {
            return;
        }
        // 手工渠道校验付款单类型
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            Assert.notNull(this.payTypeId, "付款单类型定义ID不能为空");
            Assert.notNull(this.payTypeCode, "付款单类型定义编码不能为空");
            Assert.notNull(this.payTypeName, "付款单类型定义名称不能为空");

            Assert.notNull(this.exchangeRate, "汇率不能为空");
            Assert.notNull(this.ouId, "公司ID不能为空");
            Assert.notNull(this.ouName, "公司名称不能为空");
            Assert.notNull(this.ouCode, "公司编码不能为空");
            Assert.notNull(this.currCode, "币种编码不能为空");
            Assert.notNull(this.currName, "币种名称不能为空");
            Assert.notNull(this.suppId, "供应商ID不能为空");
            Assert.notNull(this.suppCode, "供应商编码不能为空");
            Assert.notNull(this.suppName, "供应商名称不能为空");
            Assert.notNull(this.buDate, "业务日期不能为空");
            Assert.notNull(this.apDate, "预计付款日期不能为空");
            Assert.notNull(this.apFlag, "是否预付不能为空");
            Assert.notNull(this.localCurrCode, "本位币编码不能为空");
            Assert.notEmpty(this.localCurrName, "本位币名称不能为空");
        }
        // 采购
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_PO.getValueCode())) {
            Assert.notNull(this.currCode, "币种编码不能为空");
            Assert.notNull(this.currName, "币种名称不能为空");
            Assert.notNull(this.suppCode, "供应商编码不能为空");
            Assert.notNull(this.suppName, "供应商名称不能为空");
            Assert.notNull(this.exchangeRate, "汇率不能为空");
            Assert.notNull(this.ouId, "公司ID不能为空");
            Assert.notNull(this.ouName, "公司名称不能为空");
            Assert.notNull(this.ouCode, "公司编码不能为空");
            Assert.notNull(this.apFlag, "是否预付不能为空");
            Assert.notNull(this.localCurrCode, "本位币编码不能为空");
            Assert.notEmpty(this.localCurrName, "本位币名称不能为空");

        }

    }

    /**
     * 来源为对账单的设置默认信息
     */
    public void setPoDef() {
        this.realPayAmt = this.totalAmt;
        this.initFlag = false;
        if (null == this.buDate) {
            buDate = LocalDateTime.now();
        }
    }


}
